/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListVPCAssociationAuthorizationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListVPCAssociationAuthorizationsResponseUnmarshaller implements
        Unmarshaller<ListVPCAssociationAuthorizationsResponse, StaxUnmarshallerContext> {

    public ListVPCAssociationAuthorizationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListVPCAssociationAuthorizationsResponse.Builder listVPCAssociationAuthorizationsResponse = ListVPCAssociationAuthorizationsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VPC> vpCs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listVPCAssociationAuthorizationsResponse.vpCs(vpCs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HostedZoneId", targetDepth)) {
                    listVPCAssociationAuthorizationsResponse.hostedZoneId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listVPCAssociationAuthorizationsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VPCs", targetDepth)) {
                    vpCs = new ArrayList<VPC>();
                    continue;
                }

                if (context.testExpression("VPCs/VPC", targetDepth)) {
                    vpCs.add(VPCUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listVPCAssociationAuthorizationsResponse.vpCs(vpCs);
                    break;
                }
            }
        }
        return listVPCAssociationAuthorizationsResponse.build();
    }

    private static final ListVPCAssociationAuthorizationsResponseUnmarshaller INSTANCE = new ListVPCAssociationAuthorizationsResponseUnmarshaller();

    public static ListVPCAssociationAuthorizationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
