/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ResourceRecordSet StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ResourceRecordSetUnmarshaller implements Unmarshaller<ResourceRecordSet, StaxUnmarshallerContext> {

    public ResourceRecordSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceRecordSet.Builder resourceRecordSet = ResourceRecordSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ResourceRecord> resourceRecords = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                resourceRecordSet.resourceRecords(resourceRecords);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Name", targetDepth)) {
                    resourceRecordSet.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Type", targetDepth)) {
                    resourceRecordSet.type(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SetIdentifier", targetDepth)) {
                    resourceRecordSet.setIdentifier(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Weight", targetDepth)) {
                    resourceRecordSet.weight(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Region", targetDepth)) {
                    resourceRecordSet.region(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("GeoLocation", targetDepth)) {
                    resourceRecordSet.geoLocation(GeoLocationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Failover", targetDepth)) {
                    resourceRecordSet.failover(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MultiValueAnswer", targetDepth)) {
                    resourceRecordSet.multiValueAnswer(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TTL", targetDepth)) {
                    resourceRecordSet.ttl(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ResourceRecords", targetDepth)) {
                    resourceRecords = new ArrayList<ResourceRecord>();
                    continue;
                }

                if (context.testExpression("ResourceRecords/ResourceRecord", targetDepth)) {
                    resourceRecords.add(ResourceRecordUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AliasTarget", targetDepth)) {
                    resourceRecordSet.aliasTarget(AliasTargetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HealthCheckId", targetDepth)) {
                    resourceRecordSet.healthCheckId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrafficPolicyInstanceId", targetDepth)) {
                    resourceRecordSet.trafficPolicyInstanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    resourceRecordSet.resourceRecords(resourceRecords);
                    break;
                }
            }
        }
        return resourceRecordSet.build();
    }

    private static final ResourceRecordSetUnmarshaller INSTANCE = new ResourceRecordSetUnmarshaller();

    public static ResourceRecordSetUnmarshaller getInstance() {
        return INSTANCE;
    }
}
