/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListOperations response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOperationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListOperationsResponse.Builder, ListOperationsResponse> {
    private final List<OperationSummary> operations;

    private final String nextPageMarker;

    private ListOperationsResponse(BuilderImpl builder) {
        this.operations = builder.operations;
        this.nextPageMarker = builder.nextPageMarker;
    }

    /**
     * <p>
     * Lists summaries of the operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Lists summaries of the operations.
     */
    public List<OperationSummary> operations() {
        return operations;
    }

    /**
     * <p>
     * If there are more operations than you specified for <code>MaxItems</code> in the request, submit another request
     * and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * 
     * @return If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
     *         request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     */
    public String nextPageMarker() {
        return nextPageMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operations() == null) ? 0 : operations().hashCode());
        hashCode = 31 * hashCode + ((nextPageMarker() == null) ? 0 : nextPageMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse) obj;
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        if (other.operations() != null && !other.operations().equals(this.operations())) {
            return false;
        }
        if (other.nextPageMarker() == null ^ this.nextPageMarker() == null) {
            return false;
        }
        if (other.nextPageMarker() != null && !other.nextPageMarker().equals(this.nextPageMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operations() != null) {
            sb.append("Operations: ").append(operations()).append(",");
        }
        if (nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(nextPageMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListOperationsResponse> {
        /**
         * <p>
         * Lists summaries of the operations.
         * </p>
         * 
         * @param operations
         *        Lists summaries of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<OperationSummary> operations);

        /**
         * <p>
         * Lists summaries of the operations.
         * </p>
         * 
         * @param operations
         *        Lists summaries of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(OperationSummary... operations);

        /**
         * <p>
         * If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
         * request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more operations than you specified for <code>MaxItems</code> in the request, submit
         *        another request and include the value of <code>NextPageMarker</code> in the value of
         *        <code>Marker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);
    }

    private static final class BuilderImpl implements Builder {
        private List<OperationSummary> operations;

        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            setOperations(model.operations);
            setNextPageMarker(model.nextPageMarker);
        }

        public final Collection<OperationSummary> getOperations() {
            return operations;
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }
    }
}
