/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListTrafficPolicyVersionsRequestMarshaller
implements Marshaller<Request<ListTrafficPolicyVersionsRequest>, ListTrafficPolicyVersionsRequest> {
    public Request<ListTrafficPolicyVersionsRequest> marshall(ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {
        if (listTrafficPolicyVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTrafficPolicyVersionsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/trafficpolicies/{Id}/versions";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", listTrafficPolicyVersionsRequest.id());
        request.setResourcePath(uriResourcePath);
        if (listTrafficPolicyVersionsRequest.trafficPolicyVersionMarker() != null) {
            request.addParameter("trafficpolicyversion", StringUtils.fromString((String)listTrafficPolicyVersionsRequest.trafficPolicyVersionMarker()));
        }
        if (listTrafficPolicyVersionsRequest.maxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listTrafficPolicyVersionsRequest.maxItems()));
        }
        return request;
    }
}

