/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.services.route53domains.model.DomainSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDomainsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDomainsResponse> {
    private final List<DomainSummary> domains;
    private final String nextPageMarker;

    private ListDomainsResponse(BuilderImpl builder) {
        this.domains = builder.domains;
        this.nextPageMarker = builder.nextPageMarker;
    }

    public List<DomainSummary> domains() {
        return this.domains;
    }

    public String nextPageMarker() {
        return this.nextPageMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domains() == null ? 0 : this.domains().hashCode());
        hashCode = 31 * hashCode + (this.nextPageMarker() == null ? 0 : this.nextPageMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse)((Object)obj);
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.nextPageMarker() == null ^ this.nextPageMarker() == null) {
            return false;
        }
        return other.nextPageMarker() == null || other.nextPageMarker().equals(this.nextPageMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domains() != null) {
            sb.append("Domains: ").append(this.domains()).append(",");
        }
        if (this.nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(this.nextPageMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DomainSummary> domains;
        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            this.setDomains(model.domains);
            this.setNextPageMarker(model.nextPageMarker);
        }

        public final Collection<DomainSummary> getDomains() {
            return this.domains;
        }

        @Override
        public final Builder domains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainSummary ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDomainsResponse> {
        public Builder domains(Collection<DomainSummary> var1);

        public Builder domains(DomainSummary ... var1);

        public Builder nextPageMarker(String var1);
    }
}

