/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>AssociateVPCWithHostedZone</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociateVPCWithHostedZoneResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AssociateVPCWithHostedZoneResponse.Builder, AssociateVPCWithHostedZoneResponse> {
    private final ChangeInfo changeInfo;

    private AssociateVPCWithHostedZoneResponse(BuilderImpl builder) {
        this.changeInfo = builder.changeInfo;
    }

    /**
     * <p>
     * A complex type that describes the changes made to your hosted zone.
     * </p>
     * 
     * @return A complex type that describes the changes made to your hosted zone.
     */
    public ChangeInfo changeInfo() {
        return changeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((changeInfo() == null) ? 0 : changeInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVPCWithHostedZoneResponse)) {
            return false;
        }
        AssociateVPCWithHostedZoneResponse other = (AssociateVPCWithHostedZoneResponse) obj;
        if (other.changeInfo() == null ^ this.changeInfo() == null) {
            return false;
        }
        if (other.changeInfo() != null && !other.changeInfo().equals(this.changeInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (changeInfo() != null) {
            sb.append("ChangeInfo: ").append(changeInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeInfo":
            return Optional.of(clazz.cast(changeInfo()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AssociateVPCWithHostedZoneResponse> {
        /**
         * <p>
         * A complex type that describes the changes made to your hosted zone.
         * </p>
         * 
         * @param changeInfo
         *        A complex type that describes the changes made to your hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);
    }

    static final class BuilderImpl implements Builder {
        private ChangeInfo changeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVPCWithHostedZoneResponse model) {
            changeInfo(model.changeInfo);
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return changeInfo != null ? changeInfo.toBuilder() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        @Override
        public AssociateVPCWithHostedZoneResponse build() {
            return new AssociateVPCWithHostedZoneResponse(this);
        }
    }
}
