/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for each resource record set that you want to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Change implements ToCopyableBuilder<Change.Builder, Change> {
    private final String action;

    private final ResourceRecordSet resourceRecordSet;

    private Change(BuilderImpl builder) {
        this.action = builder.action;
        this.resourceRecordSet = builder.resourceRecordSet;
    }

    /**
     * <p>
     * The action to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes a existing resource record set.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use
     * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon Route
     * 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     * it's no longer in use.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a resource
     * record set does exist, Amazon Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The values that you need to include in the request depend on the type of resource record set that you're
     * creating, deleting, or updating:
     * </p>
     * <p>
     * <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource record
     * sets)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TTL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record sets)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TTL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SetIdentifier</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted alias
     * resource record sets)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
     * <code>HostedZoneId</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionString}.
     * </p>
     * 
     * @return The action to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: Creates a resource record set that has the specified values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: Deletes a existing resource record set.
     *         </p>
     *         <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use
     *         <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     *         automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
     *         Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
     *         charged for it even though it's no longer in use.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
     *         resource record set does exist, Amazon Route 53 updates it with the values in the request.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The values that you need to include in the request depend on the type of resource record set that you're
     *         creating, deleting, or updating:
     *         </p>
     *         <p>
     *         <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource
     *         record sets)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TTL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record
     *         sets)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TTL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SetIdentifier</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted
     *         alias resource record sets)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
     *         <code>HostedZoneId</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
     *         </p>
     *         </li>
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes a existing resource record set.
     * </p>
     * <important>
     * <p>
     * To delete the resource record set that is associated with a traffic policy instance, use
     * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon Route
     * 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it even though
     * it's no longer in use.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a resource
     * record set does exist, Amazon Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The values that you need to include in the request depend on the type of resource record set that you're
     * creating, deleting, or updating:
     * </p>
     * <p>
     * <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource record
     * sets)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TTL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record sets)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TTL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SetIdentifier</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted alias
     * resource record sets)</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Type</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
     * <code>HostedZoneId</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionString}.
     * </p>
     * 
     * @return The action to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE</code>: Creates a resource record set that has the specified values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE</code>: Deletes a existing resource record set.
     *         </p>
     *         <important>
     *         <p>
     *         To delete the resource record set that is associated with a traffic policy instance, use
     *         <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
     *         automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
     *         Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
     *         charged for it even though it's no longer in use.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
     *         resource record set does exist, Amazon Route 53 updates it with the values in the request.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The values that you need to include in the request depend on the type of resource record set that you're
     *         creating, deleting, or updating:
     *         </p>
     *         <p>
     *         <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource
     *         record sets)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TTL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record
     *         sets)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TTL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SetIdentifier</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted
     *         alias resource record sets)</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Type</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
     *         <code>HostedZoneId</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
     *         </p>
     *         </li>
     * @see ChangeAction
     */
    public String actionString() {
        return action;
    }

    /**
     * <p>
     * Information about the resource record set to create, delete, or update.
     * </p>
     * 
     * @return Information about the resource record set to create, delete, or update.
     */
    public ResourceRecordSet resourceRecordSet() {
        return resourceRecordSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((actionString() == null) ? 0 : actionString().hashCode());
        hashCode = 31 * hashCode + ((resourceRecordSet() == null) ? 0 : resourceRecordSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        if (other.actionString() == null ^ this.actionString() == null) {
            return false;
        }
        if (other.actionString() != null && !other.actionString().equals(this.actionString())) {
            return false;
        }
        if (other.resourceRecordSet() == null ^ this.resourceRecordSet() == null) {
            return false;
        }
        if (other.resourceRecordSet() != null && !other.resourceRecordSet().equals(this.resourceRecordSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (actionString() != null) {
            sb.append("Action: ").append(actionString()).append(",");
        }
        if (resourceRecordSet() != null) {
            sb.append("ResourceRecordSet: ").append(resourceRecordSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.of(clazz.cast(actionString()));
        case "ResourceRecordSet":
            return Optional.of(clazz.cast(resourceRecordSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The action to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE</code>: Creates a resource record set that has the specified values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE</code>: Deletes a existing resource record set.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use
         * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon
         * Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it
         * even though it's no longer in use.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         * resource record set does exist, Amazon Route 53 updates it with the values in the request.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The values that you need to include in the request depend on the type of resource record set that you're
         * creating, deleting, or updating:
         * </p>
         * <p>
         * <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource record
         * sets)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TTL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record
         * sets)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TTL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SetIdentifier</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted alias
         * resource record sets)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
         * <code>HostedZoneId</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: Creates a resource record set that has the specified values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: Deletes a existing resource record set.
         *        </p>
         *        <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use
         *        <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         *        automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
         *        Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
         *        charged for it even though it's no longer in use.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         *        resource record set does exist, Amazon Route 53 updates it with the values in the request.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The values that you need to include in the request depend on the type of resource record set that
         *        you're creating, deleting, or updating:
         *        </p>
         *        <p>
         *        <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource
         *        record sets)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TTL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record
         *        sets)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TTL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SetIdentifier</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and
         *        weighted alias resource record sets)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
         *        <code>HostedZoneId</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
         *        </p>
         *        </li>
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE</code>: Creates a resource record set that has the specified values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE</code>: Deletes a existing resource record set.
         * </p>
         * <important>
         * <p>
         * To delete the resource record set that is associated with a traffic policy instance, use
         * <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         * automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>, Amazon
         * Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be charged for it
         * even though it's no longer in use.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         * resource record set does exist, Amazon Route 53 updates it with the values in the request.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The values that you need to include in the request depend on the type of resource record set that you're
         * creating, deleting, or updating:
         * </p>
         * <p>
         * <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource record
         * sets)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TTL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record
         * sets)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TTL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SetIdentifier</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and weighted alias
         * resource record sets)</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Type</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
         * <code>HostedZoneId</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        The action to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE</code>: Creates a resource record set that has the specified values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE</code>: Deletes a existing resource record set.
         *        </p>
         *        <important>
         *        <p>
         *        To delete the resource record set that is associated with a traffic policy instance, use
         *        <code> <a>DeleteTrafficPolicyInstance</a> </code>. Amazon Route 53 will delete the resource record set
         *        automatically. If you delete the resource record set by using <code>ChangeResourceRecordSets</code>,
         *        Amazon Route 53 doesn't automatically delete the traffic policy instance, and you'll continue to be
         *        charged for it even though it's no longer in use.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>UPSERT</code>: If a resource record set doesn't already exist, Amazon Route 53 creates it. If a
         *        resource record set does exist, Amazon Route 53 updates it with the values in the request.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The values that you need to include in the request depend on the type of resource record set that
         *        you're creating, deleting, or updating:
         *        </p>
         *        <p>
         *        <b>Basic resource record sets (excluding alias, failover, geolocation, latency, and weighted resource
         *        record sets)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TTL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Failover, geolocation, latency, or weighted resource record sets (excluding alias resource record
         *        sets)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TTL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SetIdentifier</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Alias resource record sets (including failover alias, geolocation alias, latency alias, and
         *        weighted alias resource record sets)</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Type</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AliasTarget</code> (includes <code>DNSName</code>, <code>EvaluateTargetHealth</code>, and
         *        <code>HostedZoneId</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SetIdentifier</code> (for failover, geolocation, latency, and weighted resource record sets)
         *        </p>
         *        </li>
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Information about the resource record set to create, delete, or update.
         * </p>
         * 
         * @param resourceRecordSet
         *        Information about the resource record set to create, delete, or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSet(ResourceRecordSet resourceRecordSet);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private ResourceRecordSet resourceRecordSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            action(model.action);
            resourceRecordSet(model.resourceRecordSet);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ResourceRecordSet.Builder getResourceRecordSet() {
            return resourceRecordSet != null ? resourceRecordSet.toBuilder() : null;
        }

        @Override
        public final Builder resourceRecordSet(ResourceRecordSet resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet;
            return this;
        }

        public final void setResourceRecordSet(ResourceRecordSet.BuilderImpl resourceRecordSet) {
            this.resourceRecordSet = resourceRecordSet != null ? resourceRecordSet.build() : null;
        }

        @Override
        public Change build() {
            return new Change(this);
        }
    }
}
