/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that you want to create based on a specified
 * traffic policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTrafficPolicyInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateTrafficPolicyInstanceRequest.Builder, CreateTrafficPolicyInstanceRequest> {
    private final String hostedZoneId;

    private final String name;

    private final Long ttl;

    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private CreateTrafficPolicyInstanceRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.ttl = builder.ttl;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
    }

    /**
     * <p>
     * The ID of the hosted zone in which you want Amazon Route 53 to create resource record sets by using the
     * configuration in a traffic policy.
     * </p>
     * 
     * @return The ID of the hosted zone in which you want Amazon Route 53 to create resource record sets by using the
     *         configuration in a traffic policy.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53
     * responds to DNS queries by using the resource record sets that Amazon Route 53 creates for this traffic policy
     * instance.
     * </p>
     * 
     * @return The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route
     *         53 responds to DNS queries by using the resource record sets that Amazon Route 53 creates for this
     *         traffic policy instance.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in
     * the specified hosted zone.
     * </p>
     * 
     * @return (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it
     *         creates in the specified hosted zone.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     * </p>
     * 
     * @return The ID of the traffic policy that you want to use to create resource record sets in the specified hosted
     *         zone.
     */
    public String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy that you want to use to create resource record sets in the specified hosted
     * zone.
     * </p>
     * 
     * @return The version of the traffic policy that you want to use to create resource record sets in the specified
     *         hosted zone.
     */
    public Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((ttl() == null) ? 0 : ttl().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyId() == null) ? 0 : trafficPolicyId().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyVersion() == null) ? 0 : trafficPolicyVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyInstanceRequest)) {
            return false;
        }
        CreateTrafficPolicyInstanceRequest other = (CreateTrafficPolicyInstanceRequest) obj;
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.ttl() == null ^ this.ttl() == null) {
            return false;
        }
        if (other.ttl() != null && !other.ttl().equals(this.ttl())) {
            return false;
        }
        if (other.trafficPolicyId() == null ^ this.trafficPolicyId() == null) {
            return false;
        }
        if (other.trafficPolicyId() != null && !other.trafficPolicyId().equals(this.trafficPolicyId())) {
            return false;
        }
        if (other.trafficPolicyVersion() == null ^ this.trafficPolicyVersion() == null) {
            return false;
        }
        if (other.trafficPolicyVersion() != null && !other.trafficPolicyVersion().equals(this.trafficPolicyVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (ttl() != null) {
            sb.append("TTL: ").append(ttl()).append(",");
        }
        if (trafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(trafficPolicyId()).append(",");
        }
        if (trafficPolicyVersion() != null) {
            sb.append("TrafficPolicyVersion: ").append(trafficPolicyVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "TTL":
            return Optional.of(clazz.cast(ttl()));
        case "TrafficPolicyId":
            return Optional.of(clazz.cast(trafficPolicyId()));
        case "TrafficPolicyVersion":
            return Optional.of(clazz.cast(trafficPolicyVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTrafficPolicyInstanceRequest> {
        /**
         * <p>
         * The ID of the hosted zone in which you want Amazon Route 53 to create resource record sets by using the
         * configuration in a traffic policy.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone in which you want Amazon Route 53 to create resource record sets by using
         *        the configuration in a traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53
         * responds to DNS queries by using the resource record sets that Amazon Route 53 creates for this traffic
         * policy instance.
         * </p>
         * 
         * @param name
         *        The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon
         *        Route 53 responds to DNS queries by using the resource record sets that Amazon Route 53 creates for
         *        this traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates
         * in the specified hosted zone.
         * </p>
         * 
         * @param ttl
         *        (Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it
         *        creates in the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The ID of the traffic policy that you want to use to create resource record sets in the specified hosted
         * zone.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that you want to use to create resource record sets in the specified
         *        hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy that you want to use to create resource record sets in the specified hosted
         * zone.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy that you want to use to create resource record sets in the specified
         *        hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String name;

        private Long ttl;

        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyInstanceRequest model) {
            hostedZoneId(model.hostedZoneId);
            name(model.name);
            ttl(model.ttl);
            trafficPolicyId(model.trafficPolicyId);
            trafficPolicyVersion(model.trafficPolicyVersion);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getTTL() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public CreateTrafficPolicyInstanceRequest build() {
            return new CreateTrafficPolicyInstanceRequest(this);
        }
    }
}
