/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheck</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHealthCheckResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetHealthCheckResponse.Builder, GetHealthCheckResponse> {
    private final HealthCheck healthCheck;

    private GetHealthCheckResponse(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
    }

    /**
     * <p>
     * A complex type that contains information about one health check that is associated with the current AWS account.
     * </p>
     * 
     * @return A complex type that contains information about one health check that is associated with the current AWS
     *         account.
     */
    public HealthCheck healthCheck() {
        return healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((healthCheck() == null) ? 0 : healthCheck().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckResponse)) {
            return false;
        }
        GetHealthCheckResponse other = (GetHealthCheckResponse) obj;
        if (other.healthCheck() == null ^ this.healthCheck() == null) {
            return false;
        }
        if (other.healthCheck() != null && !other.healthCheck().equals(this.healthCheck())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (healthCheck() != null) {
            sb.append("HealthCheck: ").append(healthCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheck":
            return Optional.of(clazz.cast(healthCheck()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetHealthCheckResponse> {
        /**
         * <p>
         * A complex type that contains information about one health check that is associated with the current AWS
         * account.
         * </p>
         * 
         * @param healthCheck
         *        A complex type that contains information about one health check that is associated with the current
         *        AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(HealthCheck healthCheck);
    }

    static final class BuilderImpl implements Builder {
        private HealthCheck healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckResponse model) {
            healthCheck(model.healthCheck);
        }

        public final HealthCheck.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public GetHealthCheckResponse build() {
            return new GetHealthCheckResponse(this);
        }
    }
}
