/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHostedZoneCount</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostedZoneCountResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetHostedZoneCountResponse.Builder, GetHostedZoneCountResponse> {
    private final Long hostedZoneCount;

    private GetHostedZoneCountResponse(BuilderImpl builder) {
        this.hostedZoneCount = builder.hostedZoneCount;
    }

    /**
     * <p>
     * The total number of public and private hosted zones that are associated with the current AWS account.
     * </p>
     * 
     * @return The total number of public and private hosted zones that are associated with the current AWS account.
     */
    public Long hostedZoneCount() {
        return hostedZoneCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneCount() == null) ? 0 : hostedZoneCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneCountResponse)) {
            return false;
        }
        GetHostedZoneCountResponse other = (GetHostedZoneCountResponse) obj;
        if (other.hostedZoneCount() == null ^ this.hostedZoneCount() == null) {
            return false;
        }
        if (other.hostedZoneCount() != null && !other.hostedZoneCount().equals(this.hostedZoneCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostedZoneCount() != null) {
            sb.append("HostedZoneCount: ").append(hostedZoneCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneCount":
            return Optional.of(clazz.cast(hostedZoneCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetHostedZoneCountResponse> {
        /**
         * <p>
         * The total number of public and private hosted zones that are associated with the current AWS account.
         * </p>
         * 
         * @param hostedZoneCount
         *        The total number of public and private hosted zones that are associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneCount(Long hostedZoneCount);
    }

    static final class BuilderImpl implements Builder {
        private Long hostedZoneCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneCountResponse model) {
            hostedZoneCount(model.hostedZoneCount);
        }

        public final Long getHostedZoneCount() {
            return hostedZoneCount;
        }

        @Override
        public final Builder hostedZoneCount(Long hostedZoneCount) {
            this.hostedZoneCount = hostedZoneCount;
            return this;
        }

        public final void setHostedZoneCount(Long hostedZoneCount) {
            this.hostedZoneCount = hostedZoneCount;
        }

        @Override
        public GetHostedZoneCountResponse build() {
            return new GetHostedZoneCountResponse(this);
        }
    }
}
