/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to the <code>GetReusableDelegationSet</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetReusableDelegationSetResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetReusableDelegationSetResponse.Builder, GetReusableDelegationSetResponse> {
    private final DelegationSet delegationSet;

    private GetReusableDelegationSetResponse(BuilderImpl builder) {
        this.delegationSet = builder.delegationSet;
    }

    /**
     * <p>
     * A complex type that contains information about the reusable delegation set.
     * </p>
     * 
     * @return A complex type that contains information about the reusable delegation set.
     */
    public DelegationSet delegationSet() {
        return delegationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((delegationSet() == null) ? 0 : delegationSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetResponse)) {
            return false;
        }
        GetReusableDelegationSetResponse other = (GetReusableDelegationSetResponse) obj;
        if (other.delegationSet() == null ^ this.delegationSet() == null) {
            return false;
        }
        if (other.delegationSet() != null && !other.delegationSet().equals(this.delegationSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (delegationSet() != null) {
            sb.append("DelegationSet: ").append(delegationSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegationSet":
            return Optional.of(clazz.cast(delegationSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetReusableDelegationSetResponse> {
        /**
         * <p>
         * A complex type that contains information about the reusable delegation set.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that contains information about the reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);
    }

    static final class BuilderImpl implements Builder {
        private DelegationSet delegationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetResponse model) {
            delegationSet(model.delegationSet);
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        @Override
        public GetReusableDelegationSetResponse build() {
            return new GetReusableDelegationSetResponse(this);
        }
    }
}
