/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about one health check that is associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HealthCheck implements ToCopyableBuilder<HealthCheck.Builder, HealthCheck> {
    private final String id;

    private final String callerReference;

    private final HealthCheckConfig healthCheckConfig;

    private final Long healthCheckVersion;

    private final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

    private HealthCheck(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.cloudWatchAlarmConfiguration = builder.cloudWatchAlarmConfiguration;
    }

    /**
     * <p>
     * The identifier that Amazon Route 53assigned to the health check when you created it. When you add or update a
     * resource record set, you use this value to specify which health check to use. The value can be up to 64
     * characters long.
     * </p>
     * 
     * @return The identifier that Amazon Route 53assigned to the health check when you created it. When you add or
     *         update a resource record set, you use this value to specify which health check to use. The value can be
     *         up to 64 characters long.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A unique string that you specified when you created the health check.
     * </p>
     * 
     * @return A unique string that you specified when you created the health check.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains detailed information about one health check.
     * </p>
     * 
     * @return A complex type that contains detailed information about one health check.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * <p>
     * The version of the health check. You can optionally pass this value in a call to <code>UpdateHealthCheck</code>
     * to prevent overwriting another change to the health check.
     * </p>
     * 
     * @return The version of the health check. You can optionally pass this value in a call to
     *         <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
     */
    public Long healthCheckVersion() {
        return healthCheckVersion;
    }

    /**
     * <p>
     * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this
     * health check.
     * </p>
     * 
     * @return A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring
     *         for this health check.
     */
    public CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration() {
        return cloudWatchAlarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((callerReference() == null) ? 0 : callerReference().hashCode());
        hashCode = 31 * hashCode + ((healthCheckConfig() == null) ? 0 : healthCheckConfig().hashCode());
        hashCode = 31 * hashCode + ((healthCheckVersion() == null) ? 0 : healthCheckVersion().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchAlarmConfiguration() == null) ? 0 : cloudWatchAlarmConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.healthCheckConfig() == null ^ this.healthCheckConfig() == null) {
            return false;
        }
        if (other.healthCheckConfig() != null && !other.healthCheckConfig().equals(this.healthCheckConfig())) {
            return false;
        }
        if (other.healthCheckVersion() == null ^ this.healthCheckVersion() == null) {
            return false;
        }
        if (other.healthCheckVersion() != null && !other.healthCheckVersion().equals(this.healthCheckVersion())) {
            return false;
        }
        if (other.cloudWatchAlarmConfiguration() == null ^ this.cloudWatchAlarmConfiguration() == null) {
            return false;
        }
        if (other.cloudWatchAlarmConfiguration() != null
                && !other.cloudWatchAlarmConfiguration().equals(this.cloudWatchAlarmConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (callerReference() != null) {
            sb.append("CallerReference: ").append(callerReference()).append(",");
        }
        if (healthCheckConfig() != null) {
            sb.append("HealthCheckConfig: ").append(healthCheckConfig()).append(",");
        }
        if (healthCheckVersion() != null) {
            sb.append("HealthCheckVersion: ").append(healthCheckVersion()).append(",");
        }
        if (cloudWatchAlarmConfiguration() != null) {
            sb.append("CloudWatchAlarmConfiguration: ").append(cloudWatchAlarmConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "HealthCheckConfig":
            return Optional.of(clazz.cast(healthCheckConfig()));
        case "HealthCheckVersion":
            return Optional.of(clazz.cast(healthCheckVersion()));
        case "CloudWatchAlarmConfiguration":
            return Optional.of(clazz.cast(cloudWatchAlarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HealthCheck> {
        /**
         * <p>
         * The identifier that Amazon Route 53assigned to the health check when you created it. When you add or update a
         * resource record set, you use this value to specify which health check to use. The value can be up to 64
         * characters long.
         * </p>
         * 
         * @param id
         *        The identifier that Amazon Route 53assigned to the health check when you created it. When you add or
         *        update a resource record set, you use this value to specify which health check to use. The value can
         *        be up to 64 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique string that you specified when you created the health check.
         * </p>
         * 
         * @param callerReference
         *        A unique string that you specified when you created the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains detailed information about one health check.
         * </p>
         * 
         * @param healthCheckConfig
         *        A complex type that contains detailed information about one health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * The version of the health check. You can optionally pass this value in a call to
         * <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
         * </p>
         * 
         * @param healthCheckVersion
         *        The version of the health check. You can optionally pass this value in a call to
         *        <code>UpdateHealthCheck</code> to prevent overwriting another change to the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckVersion(Long healthCheckVersion);

        /**
         * <p>
         * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for
         * this health check.
         * </p>
         * 
         * @param cloudWatchAlarmConfiguration
         *        A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring
         *        for this health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String callerReference;

        private HealthCheckConfig healthCheckConfig;

        private Long healthCheckVersion;

        private CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            id(model.id);
            callerReference(model.callerReference);
            healthCheckConfig(model.healthCheckConfig);
            healthCheckVersion(model.healthCheckVersion);
            cloudWatchAlarmConfiguration(model.cloudWatchAlarmConfiguration);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final Long getHealthCheckVersion() {
            return healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        public final CloudWatchAlarmConfiguration.Builder getCloudWatchAlarmConfiguration() {
            return cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
            return this;
        }

        public final void setCloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.BuilderImpl cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.build()
                    : null;
        }

        @Override
        public HealthCheck build() {
            return new HealthCheck(this);
        }
    }
}
