/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The health check you're attempting to create already exists. Amazon Route 53 returns this error when you submit a
 * request that has the following values:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The same value for <code>CallerReference</code> as an existing health check, and one or more values that differ from
 * the existing health check that has the same caller reference.
 * </p>
 * </li>
 * <li>
 * <p>
 * The same value for <code>CallerReference</code> as a health check that you created and later deleted, regardless of
 * the other settings in the request.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class HealthCheckAlreadyExistsException extends Route53Exception implements
        ToCopyableBuilder<HealthCheckAlreadyExistsException.Builder, HealthCheckAlreadyExistsException> {
    private HealthCheckAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, HealthCheckAlreadyExistsException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckAlreadyExistsException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public HealthCheckAlreadyExistsException build() {
            return new HealthCheckAlreadyExistsException(this);
        }
    }
}
