/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains general information about the hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostedZone implements ToCopyableBuilder<HostedZone.Builder, HostedZone> {
    private final String id;

    private final String name;

    private final String callerReference;

    private final HostedZoneConfig config;

    private final Long resourceRecordSetCount;

    private HostedZone(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.callerReference = builder.callerReference;
        this.config = builder.config;
        this.resourceRecordSetCount = builder.resourceRecordSetCount;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     * registrar.
     * </p>
     * <p>
     * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and <code>-</code>
     * (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.
     * </p>
     * 
     * @return The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     *         registrar.</p>
     *         <p>
     *         For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
     *         <code>-</code> (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value that you specified for <code>CallerReference</code> when you created the hosted zone.
     * </p>
     * 
     * @return The value that you specified for <code>CallerReference</code> when you created the hosted zone.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted the
     * <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code> and
     * <code>Comment</code> elements don't appear in the response.
     * </p>
     * 
     * @return A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you
     *         omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the
     *         <code>Config</code> and <code>Comment</code> elements don't appear in the response.
     */
    public HostedZoneConfig config() {
        return config;
    }

    /**
     * <p>
     * The number of resource record sets in the hosted zone.
     * </p>
     * 
     * @return The number of resource record sets in the hosted zone.
     */
    public Long resourceRecordSetCount() {
        return resourceRecordSetCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((callerReference() == null) ? 0 : callerReference().hashCode());
        hashCode = 31 * hashCode + ((config() == null) ? 0 : config().hashCode());
        hashCode = 31 * hashCode + ((resourceRecordSetCount() == null) ? 0 : resourceRecordSetCount().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZone)) {
            return false;
        }
        HostedZone other = (HostedZone) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.config() == null ^ this.config() == null) {
            return false;
        }
        if (other.config() != null && !other.config().equals(this.config())) {
            return false;
        }
        if (other.resourceRecordSetCount() == null ^ this.resourceRecordSetCount() == null) {
            return false;
        }
        if (other.resourceRecordSetCount() != null && !other.resourceRecordSetCount().equals(this.resourceRecordSetCount())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (callerReference() != null) {
            sb.append("CallerReference: ").append(callerReference()).append(",");
        }
        if (config() != null) {
            sb.append("Config: ").append(config()).append(",");
        }
        if (resourceRecordSetCount() != null) {
            sb.append("ResourceRecordSetCount: ").append(resourceRecordSetCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "Config":
            return Optional.of(clazz.cast(config()));
        case "ResourceRecordSetCount":
            return Optional.of(clazz.cast(resourceRecordSetCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostedZone> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
         * registrar.
         * </p>
         * <p>
         * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         * <code>-</code> (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.
         * </p>
         * 
         * @param name
         *        The name of the domain. For public hosted zones, this is the name that you have registered with your
         *        DNS registrar.</p>
         *        <p>
         *        For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         *        <code>-</code> (hyphen) and how to specify internationalized domain names, see
         *        <a>CreateHostedZone</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value that you specified for <code>CallerReference</code> when you created the hosted zone.
         * </p>
         * 
         * @param callerReference
         *        The value that you specified for <code>CallerReference</code> when you created the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted
         * the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code>
         * and <code>Comment</code> elements don't appear in the response.
         * </p>
         * 
         * @param config
         *        A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you
         *        omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the
         *        <code>Config</code> and <code>Comment</code> elements don't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HostedZoneConfig config);

        /**
         * <p>
         * The number of resource record sets in the hosted zone.
         * </p>
         * 
         * @param resourceRecordSetCount
         *        The number of resource record sets in the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSetCount(Long resourceRecordSetCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String callerReference;

        private HostedZoneConfig config;

        private Long resourceRecordSetCount;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZone model) {
            id(model.id);
            name(model.name);
            callerReference(model.callerReference);
            config(model.config);
            resourceRecordSetCount(model.resourceRecordSetCount);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        @Override
        public final Builder config(HostedZoneConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HostedZoneConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        public final Long getResourceRecordSetCount() {
            return resourceRecordSetCount;
        }

        @Override
        public final Builder resourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
            return this;
        }

        public final void setResourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
        }

        @Override
        public HostedZone build() {
            return new HostedZone(this);
        }
    }
}
