/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>ListHealthChecks</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListHealthChecksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListHealthChecksResponse.Builder, ListHealthChecksResponse> {
    private final List<HealthCheck> healthChecks;

    private final String marker;

    private final Boolean isTruncated;

    private final String nextMarker;

    private final String maxItems;

    private ListHealthChecksResponse(BuilderImpl builder) {
        this.healthChecks = builder.healthChecks;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with
     * the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains one <code>HealthCheck</code> element for each health check that is
     *         associated with the current AWS account.
     */
    public List<HealthCheck> healthChecks() {
        return healthChecks;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you
     * specified for the <code>marker</code> parameter in the previous request.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value
     *         that you specified for the <code>marker</code> parameter in the previous request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can
     * get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying
     * the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return A flag that indicates whether there are more health checks to be listed. If the response was truncated,
     *         you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request
     *         and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
     * health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify
     * the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
     *         first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code>
     *         request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code>
     * that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListHealthChecks</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((healthChecks() == null) ? 0 : healthChecks().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksResponse)) {
            return false;
        }
        ListHealthChecksResponse other = (ListHealthChecksResponse) obj;
        if (other.healthChecks() == null ^ this.healthChecks() == null) {
            return false;
        }
        if (other.healthChecks() != null && !other.healthChecks().equals(this.healthChecks())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (healthChecks() != null) {
            sb.append("HealthChecks: ").append(healthChecks()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthChecks":
            return Optional.of(clazz.cast(healthChecks()));
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "NextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListHealthChecksResponse> {
        /**
         * <p>
         * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated
         * with the current AWS account.
         * </p>
         * 
         * @param healthChecks
         *        A complex type that contains one <code>HealthCheck</code> element for each health check that is
         *        associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthChecks(Collection<HealthCheck> healthChecks);

        /**
         * <p>
         * A complex type that contains one <code>HealthCheck</code> element for each health check that is associated
         * with the current AWS account.
         * </p>
         * 
         * @param healthChecks
         *        A complex type that contains one <code>HealthCheck</code> element for each health check that is
         *        associated with the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthChecks(HealthCheck... healthChecks);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that
         * you specified for the <code>marker</code> parameter in the previous request.
         * </p>
         * 
         * @param marker
         *        For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value
         *        that you specified for the <code>marker</code> parameter in the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A flag that indicates whether there are more health checks to be listed. If the response was truncated, you
         * can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and
         * specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more health checks to be listed. If the response was
         *        truncated, you can get the next group of health checks by submitting another
         *        <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the
         *        <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
         * health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and
         * specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
         *        first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code>
         *        request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListHealthChecks</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListHealthChecks</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl implements Builder {
        private List<HealthCheck> healthChecks;

        private String marker;

        private Boolean isTruncated;

        private String nextMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHealthChecksResponse model) {
            healthChecks(model.healthChecks);
            marker(model.marker);
            isTruncated(model.isTruncated);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
        }

        public final Collection<HealthCheck.Builder> getHealthChecks() {
            return healthChecks != null ? healthChecks.stream().map(HealthCheck::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder healthChecks(Collection<HealthCheck> healthChecks) {
            this.healthChecks = HealthChecksCopier.copy(healthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(HealthCheck... healthChecks) {
            healthChecks(Arrays.asList(healthChecks));
            return this;
        }

        public final void setHealthChecks(Collection<HealthCheck.BuilderImpl> healthChecks) {
            this.healthChecks = HealthChecksCopier.copyFromBuilder(healthChecks);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHealthChecksResponse build() {
            return new ListHealthChecksResponse(this);
        }
    }
}
