/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves a list of the public and private hosted zones that are associated with the current AWS account in ASCII
 * order by domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListHostedZonesByNameRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListHostedZonesByNameRequest.Builder, ListHostedZonesByNameRequest> {
    private final String dnsName;

    private final String hostedZoneId;

    private final String maxItems;

    private ListHostedZonesByNameRequest(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * (Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code>
     * parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the
     * <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current
     * AWS account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code>
     * from the previous response.
     * </p>
     * 
     * @return (Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code>
     *         parameter only if you want to specify the name of the first hosted zone in the response. If you don't
     *         include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were
     *         created by the current AWS account, in ASCII order. For subsequent requests, include both
     *         <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the
     *         value of <code>NextDNSName</code> from the previous response.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
     * <code>hostedzoneid</code> parameter.
     * </p>
     * <p>
     * If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns
     * only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones,
     * submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the
     * <code>NextHostedZoneId</code> element from the previous response.
     * </p>
     * 
     * @return (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
     *         <code>hostedzoneid</code> parameter.</p>
     *         <p>
     *         If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code>
     *         returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code>
     *         hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both
     *         <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>
     *         , specify the value of the <code>NextHostedZoneId</code> element from the previous response.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The maximum number of hosted zones to be included in the response body for this request. If you have more than
     * <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is
     * true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone
     * in the next group of <code>maxitems</code> hosted zones.
     * </p>
     * 
     * @return The maximum number of hosted zones to be included in the response body for this request. If you have more
     *         than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the
     *         response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify
     *         the first hosted zone in the next group of <code>maxitems</code> hosted zones.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dnsName() == null) ? 0 : dnsName().hashCode());
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameRequest)) {
            return false;
        }
        ListHostedZonesByNameRequest other = (ListHostedZonesByNameRequest) obj;
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dnsName() != null) {
            sb.append("DNSName: ").append(dnsName()).append(",");
        }
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DNSName":
            return Optional.of(clazz.cast(dnsName()));
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListHostedZonesByNameRequest> {
        /**
         * <p>
         * (Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code>
         * parameter only if you want to specify the name of the first hosted zone in the response. If you don't include
         * the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the
         * current AWS account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
         * <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code>
         * from the previous response.
         * </p>
         * 
         * @param dnsName
         *        (Optional) For your first request to <code>ListHostedZonesByName</code>, include the
         *        <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the
         *        response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the
         *        hosted zones that were created by the current AWS account, in ASCII order. For subsequent requests,
         *        include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>,
         *        specify the value of <code>NextDNSName</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
         * <code>hostedzoneid</code> parameter.
         * </p>
         * <p>
         * If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code>
         * returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code>
         * hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both
         * <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>,
         * specify the value of the <code>NextHostedZoneId</code> element from the previous response.
         * </p>
         * 
         * @param hostedZoneId
         *        (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
         *        <code>hostedzoneid</code> parameter.</p>
         *        <p>
         *        If you have more hosted zones than the value of <code>maxitems</code>,
         *        <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get
         *        the next group of <code>maxitems</code> hosted zones, submit another request to
         *        <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code>
         *        parameters. For the value of <code>hostedzoneid</code>, specify the value of the
         *        <code>NextHostedZoneId</code> element from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The maximum number of hosted zones to be included in the response body for this request. If you have more
         * than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the
         * response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the
         * first hosted zone in the next group of <code>maxitems</code> hosted zones.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of hosted zones to be included in the response body for this request. If you have
         *        more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element
         *        in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code>
         *        specify the first hosted zone in the next group of <code>maxitems</code> hosted zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl implements Builder {
        private String dnsName;

        private String hostedZoneId;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameRequest model) {
            dnsName(model.dnsName);
            hostedZoneId(model.hostedZoneId);
            maxItems(model.maxItems);
        }

        public final String getDNSName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesByNameRequest build() {
            return new ListHostedZonesByNameRequest(this);
        }
    }
}
