/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to retrieve a list of the public and private hosted zones that are associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListHostedZonesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListHostedZonesRequest.Builder, ListHostedZonesRequest> {
    private final String marker;

    private final String maxItems;

    private final String delegationSetId;

    private ListHostedZonesRequest(BuilderImpl builder) {
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.delegationSetId = builder.delegationSetId;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted
     * zones. To get more hosted zones, submit another <code>ListHostedZones</code> request.
     * </p>
     * <p>
     * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
     * which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * hosted zones to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
     *         <p>
     *         For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
     *         response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another
     *         request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more hosted zones to get.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than
     * <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>,
     * and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Amazon Route 53 will
     * return if you submit another request.
     * </p>
     * 
     * @return (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more
     *         than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is
     *         <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted
     *         zone that Amazon Route 53 will return if you submit another request.
     */
    public String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a
     * reusable delegation set, specify the ID of that reusable delegation set.
     * </p>
     * 
     * @return If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
     *         with a reusable delegation set, specify the ID of that reusable delegation set.
     */
    public String delegationSetId() {
        return delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        hashCode = 31 * hashCode + ((delegationSetId() == null) ? 0 : delegationSetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesRequest)) {
            return false;
        }
        ListHostedZonesRequest other = (ListHostedZonesRequest) obj;
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.delegationSetId() == null ^ this.delegationSetId() == null) {
            return false;
        }
        if (other.delegationSetId() != null && !other.delegationSetId().equals(this.delegationSetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (delegationSetId() != null) {
            sb.append("DelegationSetId: ").append(delegationSetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        case "DelegationSetId":
            return Optional.of(clazz.cast(delegationSetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListHostedZonesRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted
         * zones. To get more hosted zones, submit another <code>ListHostedZones</code> request.
         * </p>
         * <p>
         * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         * response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another
         * request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * hosted zones to get.
         * </p>
         * 
         * @param marker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
         *        <p>
         *        For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         *        response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit
         *        another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more hosted zones to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than
         * <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is
         * <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone
         * that Amazon Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have
         *        more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is
         *        <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted
         *        zone that Amazon Route 53 will return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
         * with a reusable delegation set, specify the ID of that reusable delegation set.
         * </p>
         * 
         * @param delegationSetId
         *        If you're using reusable delegation sets and you want to list all of the hosted zones that are
         *        associated with a reusable delegation set, specify the ID of that reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSetId(String delegationSetId);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesRequest model) {
            marker(model.marker);
            maxItems(model.maxItems);
            delegationSetId(model.delegationSetId);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getDelegationSetId() {
            return delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public ListHostedZonesRequest build() {
            return new ListHostedZonesRequest(this);
        }
    }
}
