/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get information about the traffic policy instances that you created by using the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPolicyInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTrafficPolicyInstancesRequest.Builder, ListTrafficPolicyInstancesRequest> {
    private final String hostedZoneIdMarker;

    private final String trafficPolicyInstanceNameMarker;

    private final String trafficPolicyInstanceTypeMarker;

    private final String maxItems;

    private ListTrafficPolicyInstancesRequest(BuilderImpl builder) {
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from
     * the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of
     * traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the
     *         value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the
     *         first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public String hostedZoneIdMarker() {
        return hostedZoneIdMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>trafficpolicyinstancename</code>, specify the value of
     * <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic
     * policy instance in the next group of traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
     *         specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is
     *         the name of the first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public String trafficPolicyInstanceNameMarker() {
        return trafficPolicyInstanceNameMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic
     * policy instance in the next group of traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerString}.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
     *         specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is
     *         the type of the first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(trafficPolicyInstanceTypeMarker);
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic
     * policy instance in the next group of traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerString}.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
     *         specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is
     *         the type of the first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public String trafficPolicyInstanceTypeMarkerString() {
        return trafficPolicyInstanceTypeMarker;
    }

    /**
     * <p>
     * The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a
     * <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy
     * instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values
     * of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     * <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of
     * <code>MaxItems</code> traffic policy instances.
     * </p>
     * 
     * @return The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a
     *         <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic
     *         policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
     *         and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     *         <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next
     *         group of <code>MaxItems</code> traffic policy instances.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneIdMarker() == null) ? 0 : hostedZoneIdMarker().hashCode());
        hashCode = 31 * hashCode
                + ((trafficPolicyInstanceNameMarker() == null) ? 0 : trafficPolicyInstanceNameMarker().hashCode());
        hashCode = 31 * hashCode
                + ((trafficPolicyInstanceTypeMarkerString() == null) ? 0 : trafficPolicyInstanceTypeMarkerString().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesRequest other = (ListTrafficPolicyInstancesRequest) obj;
        if (other.hostedZoneIdMarker() == null ^ this.hostedZoneIdMarker() == null) {
            return false;
        }
        if (other.hostedZoneIdMarker() != null && !other.hostedZoneIdMarker().equals(this.hostedZoneIdMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() == null ^ this.trafficPolicyInstanceNameMarker() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() != null
                && !other.trafficPolicyInstanceNameMarker().equals(this.trafficPolicyInstanceNameMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarkerString() == null ^ this.trafficPolicyInstanceTypeMarkerString() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarkerString() != null
                && !other.trafficPolicyInstanceTypeMarkerString().equals(this.trafficPolicyInstanceTypeMarkerString())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostedZoneIdMarker() != null) {
            sb.append("HostedZoneIdMarker: ").append(hostedZoneIdMarker()).append(",");
        }
        if (trafficPolicyInstanceNameMarker() != null) {
            sb.append("TrafficPolicyInstanceNameMarker: ").append(trafficPolicyInstanceNameMarker()).append(",");
        }
        if (trafficPolicyInstanceTypeMarkerString() != null) {
            sb.append("TrafficPolicyInstanceTypeMarker: ").append(trafficPolicyInstanceTypeMarkerString()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneIdMarker":
            return Optional.of(clazz.cast(hostedZoneIdMarker()));
        case "TrafficPolicyInstanceNameMarker":
            return Optional.of(clazz.cast(trafficPolicyInstanceNameMarker()));
        case "TrafficPolicyInstanceTypeMarker":
            return Optional.of(clazz.cast(trafficPolicyInstanceTypeMarkerString()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTrafficPolicyInstancesRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the
         * value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first
         * traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param hostedZoneIdMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify
         *        the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID
         *        of the first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneIdMarker(String hostedZoneIdMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
         * specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the
         * name of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceNameMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of
         *        <code>trafficpolicyinstancename</code>, specify the value of
         *        <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
         * specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the
         * type of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of
         *        <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the
         *        first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
         * specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the
         * type of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of
         *        <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the
         *        first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a
         * <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy
         * instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the
         * values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         * <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of
         * <code>MaxItems</code> traffic policy instances.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to
         *        a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic
         *        policy instances, the value of the <code>IsTruncated</code> element in the response is
         *        <code>true</code>, and the values of <code>HostedZoneIdMarker</code>,
         *        <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
         *        represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneIdMarker;

        private String trafficPolicyInstanceNameMarker;

        private String trafficPolicyInstanceTypeMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesRequest model) {
            hostedZoneIdMarker(model.hostedZoneIdMarker);
            trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            maxItems(model.maxItems);
        }

        public final String getHostedZoneIdMarker() {
            return hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPolicyInstancesRequest build() {
            return new ListTrafficPolicyInstancesRequest(this);
        }
    }
}
