/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListTrafficPolicyInstancesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListTrafficPolicyInstancesResponseUnmarshaller implements
        Unmarshaller<ListTrafficPolicyInstancesResponse, StaxUnmarshallerContext> {

    public ListTrafficPolicyInstancesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListTrafficPolicyInstancesResponse.Builder listTrafficPolicyInstancesResponse = ListTrafficPolicyInstancesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<TrafficPolicyInstance> trafficPolicyInstances = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listTrafficPolicyInstancesResponse.trafficPolicyInstances(trafficPolicyInstances);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("TrafficPolicyInstances", targetDepth)) {
                    trafficPolicyInstances = new ArrayList<TrafficPolicyInstance>();
                    continue;
                }

                if (context.testExpression("TrafficPolicyInstances/TrafficPolicyInstance", targetDepth)) {
                    trafficPolicyInstances.add(TrafficPolicyInstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HostedZoneIdMarker", targetDepth)) {
                    listTrafficPolicyInstancesResponse.hostedZoneIdMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrafficPolicyInstanceNameMarker", targetDepth)) {
                    listTrafficPolicyInstancesResponse.trafficPolicyInstanceNameMarker(StringUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrafficPolicyInstanceTypeMarker", targetDepth)) {
                    listTrafficPolicyInstancesResponse.trafficPolicyInstanceTypeMarker(StringUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listTrafficPolicyInstancesResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listTrafficPolicyInstancesResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listTrafficPolicyInstancesResponse.trafficPolicyInstances(trafficPolicyInstances);
                    break;
                }
            }
        }
        return listTrafficPolicyInstancesResponse.build();
    }

    private static final ListTrafficPolicyInstancesResponseUnmarshaller INSTANCE = new ListTrafficPolicyInstancesResponseUnmarshaller();

    public static ListTrafficPolicyInstancesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
