/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListTrafficPolicyVersionsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListTrafficPolicyVersionsResponseUnmarshaller implements
        Unmarshaller<ListTrafficPolicyVersionsResponse, StaxUnmarshallerContext> {

    public ListTrafficPolicyVersionsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListTrafficPolicyVersionsResponse.Builder listTrafficPolicyVersionsResponse = ListTrafficPolicyVersionsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<TrafficPolicy> trafficPolicies = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listTrafficPolicyVersionsResponse.trafficPolicies(trafficPolicies);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("TrafficPolicies", targetDepth)) {
                    trafficPolicies = new ArrayList<TrafficPolicy>();
                    continue;
                }

                if (context.testExpression("TrafficPolicies/TrafficPolicy", targetDepth)) {
                    trafficPolicies.add(TrafficPolicyUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listTrafficPolicyVersionsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TrafficPolicyVersionMarker", targetDepth)) {
                    listTrafficPolicyVersionsResponse.trafficPolicyVersionMarker(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listTrafficPolicyVersionsResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listTrafficPolicyVersionsResponse.trafficPolicies(trafficPolicies);
                    break;
                }
            }
        }
        return listTrafficPolicyVersionsResponse.build();
    }

    private static final ListTrafficPolicyVersionsResponseUnmarshaller INSTANCE = new ListTrafficPolicyVersionsResponseUnmarshaller();

    public static ListTrafficPolicyVersionsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
