/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListVPCAssociationAuthorizationsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListVPCAssociationAuthorizationsRequestMarshaller implements
        Marshaller<Request<ListVPCAssociationAuthorizationsRequest>, ListVPCAssociationAuthorizationsRequest> {

    public Request<ListVPCAssociationAuthorizationsRequest> marshall(
            ListVPCAssociationAuthorizationsRequest listVPCAssociationAuthorizationsRequest) {

        if (listVPCAssociationAuthorizationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListVPCAssociationAuthorizationsRequest> request = new DefaultRequest<ListVPCAssociationAuthorizationsRequest>(
                listVPCAssociationAuthorizationsRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/authorizevpcassociation";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Id", listVPCAssociationAuthorizationsRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);

        if (listVPCAssociationAuthorizationsRequest.nextToken() != null) {
            request.addParameter("nexttoken", StringUtils.fromString(listVPCAssociationAuthorizationsRequest.nextToken()));
        }

        if (listVPCAssociationAuthorizationsRequest.maxResults() != null) {
            request.addParameter("maxresults", StringUtils.fromString(listVPCAssociationAuthorizationsRequest.maxResults()));
        }

        return request;
    }

}