/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainSuggestionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetDomainSuggestionsRequest.Builder, GetDomainSuggestionsRequest> {
    private final String domainName;

    private final Integer suggestionCount;

    private final Boolean onlyAvailable;

    private GetDomainSuggestionsRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.suggestionCount = builder.suggestionCount;
        this.onlyAvailable = builder.onlyAvailable;
    }

    /**
     * <p>
     * A domain name that you want to use as the basis for a list of possible domain names. The domain name must contain
     * a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @return A domain name that you want to use as the basis for a list of possible domain names. The domain name must
     *         contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a
     *         href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The number of suggested domain names that you want Amazon Route 53 to return.
     * </p>
     * 
     * @return The number of suggested domain names that you want Amazon Route 53 to return.
     */
    public Integer suggestionCount() {
        return suggestionCount;
    }

    /**
     * <p>
     * If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are available.
     * If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names without checking
     * whether they're available to be registered. To determine whether the domain is available, you can call
     * <code>checkDomainAvailability</code> for each suggestion.
     * </p>
     * 
     * @return If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are
     *         available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names
     *         without checking whether they're available to be registered. To determine whether the domain is
     *         available, you can call <code>checkDomainAvailability</code> for each suggestion.
     */
    public Boolean onlyAvailable() {
        return onlyAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((suggestionCount() == null) ? 0 : suggestionCount().hashCode());
        hashCode = 31 * hashCode + ((onlyAvailable() == null) ? 0 : onlyAvailable().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsRequest)) {
            return false;
        }
        GetDomainSuggestionsRequest other = (GetDomainSuggestionsRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.suggestionCount() == null ^ this.suggestionCount() == null) {
            return false;
        }
        if (other.suggestionCount() != null && !other.suggestionCount().equals(this.suggestionCount())) {
            return false;
        }
        if (other.onlyAvailable() == null ^ this.onlyAvailable() == null) {
            return false;
        }
        if (other.onlyAvailable() != null && !other.onlyAvailable().equals(this.onlyAvailable())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (suggestionCount() != null) {
            sb.append("SuggestionCount: ").append(suggestionCount()).append(",");
        }
        if (onlyAvailable() != null) {
            sb.append("OnlyAvailable: ").append(onlyAvailable()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "SuggestionCount":
            return Optional.of(clazz.cast(suggestionCount()));
        case "OnlyAvailable":
            return Optional.of(clazz.cast(onlyAvailable()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainSuggestionsRequest> {
        /**
         * <p>
         * A domain name that you want to use as the basis for a list of possible domain names. The domain name must
         * contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of TLDs, see <a
         * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param domainName
         *        A domain name that you want to use as the basis for a list of possible domain names. The domain name
         *        must contain a top-level domain (TLD), such as .com, that Amazon Route 53 supports. For a list of
         *        TLDs, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The number of suggested domain names that you want Amazon Route 53 to return.
         * </p>
         * 
         * @param suggestionCount
         *        The number of suggested domain names that you want Amazon Route 53 to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionCount(Integer suggestionCount);

        /**
         * <p>
         * If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are
         * available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names without
         * checking whether they're available to be registered. To determine whether the domain is available, you can
         * call <code>checkDomainAvailability</code> for each suggestion.
         * </p>
         * 
         * @param onlyAvailable
         *        If <code>OnlyAvailable</code> is <code>true</code>, Amazon Route 53 returns only domain names that are
         *        available. If <code>OnlyAvailable</code> is <code>false</code>, Amazon Route 53 returns domain names
         *        without checking whether they're available to be registered. To determine whether the domain is
         *        available, you can call <code>checkDomainAvailability</code> for each suggestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlyAvailable(Boolean onlyAvailable);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private Integer suggestionCount;

        private Boolean onlyAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsRequest model) {
            domainName(model.domainName);
            suggestionCount(model.suggestionCount);
            onlyAvailable(model.onlyAvailable);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getSuggestionCount() {
            return suggestionCount;
        }

        @Override
        public final Builder suggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
            return this;
        }

        public final void setSuggestionCount(Integer suggestionCount) {
            this.suggestionCount = suggestionCount;
        }

        public final Boolean getOnlyAvailable() {
            return onlyAvailable;
        }

        @Override
        public final Builder onlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
            return this;
        }

        public final void setOnlyAvailable(Boolean onlyAvailable) {
            this.onlyAvailable = onlyAvailable;
        }

        @Override
        public GetDomainSuggestionsRequest build() {
            return new GetDomainSuggestionsRequest(this);
        }
    }
}
