/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListTagsForDomainRequest includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTagsForDomainRequest.Builder, ListTagsForDomainRequest> {
    private final String domainName;

    private ListTagsForDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * The domain for which you want to get a list of tags.
     * </p>
     * 
     * @return The domain for which you want to get a list of tags.
     */
    public String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForDomainRequest)) {
            return false;
        }
        ListTagsForDomainRequest other = (ListTagsForDomainRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForDomainRequest> {
        /**
         * <p>
         * The domain for which you want to get a list of tags.
         * </p>
         * 
         * @param domainName
         *        The domain for which you want to get a list of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForDomainRequest model) {
            domainName(model.domainName);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public ListTagsForDomainRequest build() {
            return new ListTagsForDomainRequest(this);
        }
    }
}
