/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.NameserverMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Nameserver includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Nameserver implements StructuredPojo, ToCopyableBuilder<Nameserver.Builder, Nameserver> {
    private final String name;

    private final List<String> glueIps;

    private Nameserver(BuilderImpl builder) {
        this.name = builder.name;
        this.glueIps = builder.glueIps;
    }

    /**
     * <p>
     * The fully qualified host name of the name server.
     * </p>
     * <p>
     * Constraint: Maximum 255 characters
     * </p>
     * 
     * @return The fully qualified host name of the name server.</p>
     *         <p>
     *         Constraint: Maximum 255 characters
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server is a
     * subdomain of the domain. For example, if your domain is example.com and the name server for the domain is
     * ns.example.com, you need to specify the IP address for ns.example.com.
     * </p>
     * <p>
     * Constraints: The list can contain only one IPv4 and one IPv6 address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name
     *         server is a subdomain of the domain. For example, if your domain is example.com and the name server for
     *         the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p>
     *         <p>
     *         Constraints: The list can contain only one IPv4 and one IPv6 address.
     */
    public List<String> glueIps() {
        return glueIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((glueIps() == null) ? 0 : glueIps().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nameserver)) {
            return false;
        }
        Nameserver other = (Nameserver) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.glueIps() == null ^ this.glueIps() == null) {
            return false;
        }
        if (other.glueIps() != null && !other.glueIps().equals(this.glueIps())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (glueIps() != null) {
            sb.append("GlueIps: ").append(glueIps()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "GlueIps":
            return Optional.of(clazz.cast(glueIps()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NameserverMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Nameserver> {
        /**
         * <p>
         * The fully qualified host name of the name server.
         * </p>
         * <p>
         * Constraint: Maximum 255 characters
         * </p>
         * 
         * @param name
         *        The fully qualified host name of the name server.</p>
         *        <p>
         *        Constraint: Maximum 255 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
         * is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain
         * is ns.example.com, you need to specify the IP address for ns.example.com.
         * </p>
         * <p>
         * Constraints: The list can contain only one IPv4 and one IPv6 address.
         * </p>
         * 
         * @param glueIps
         *        Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name
         *        server is a subdomain of the domain. For example, if your domain is example.com and the name server
         *        for the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p>
         *        <p>
         *        Constraints: The list can contain only one IPv4 and one IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueIps(Collection<String> glueIps);

        /**
         * <p>
         * Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
         * is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain
         * is ns.example.com, you need to specify the IP address for ns.example.com.
         * </p>
         * <p>
         * Constraints: The list can contain only one IPv4 and one IPv6 address.
         * </p>
         * 
         * @param glueIps
         *        Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name
         *        server is a subdomain of the domain. For example, if your domain is example.com and the name server
         *        for the domain is ns.example.com, you need to specify the IP address for ns.example.com.</p>
         *        <p>
         *        Constraints: The list can contain only one IPv4 and one IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueIps(String... glueIps);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> glueIps;

        private BuilderImpl() {
        }

        private BuilderImpl(Nameserver model) {
            name(model.name);
            glueIps(model.glueIps);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getGlueIps() {
            return glueIps;
        }

        @Override
        public final Builder glueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glueIps(String... glueIps) {
            glueIps(Arrays.asList(glueIps));
            return this;
        }

        public final void setGlueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
        }

        @Override
        public Nameserver build() {
            return new Nameserver(this);
        }
    }
}
