/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.OperationSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OperationSummary includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationSummary implements StructuredPojo, ToCopyableBuilder<OperationSummary.Builder, OperationSummary> {
    private final String operationId;

    private final String status;

    private final String type;

    private final Instant submittedDate;

    private OperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    /**
     * <p>
     * Identifier returned to track the requested action.
     * </p>
     * 
     * @return Identifier returned to track the requested action.
     */
    public String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * Type of the action requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return Type of the action requested.
     * @see OperationType
     */
    public OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * Type of the action requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return Type of the action requested.
     * @see OperationType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The date when the request was submitted.
     * </p>
     * 
     * @return The date when the request was submitted.
     */
    public Instant submittedDate() {
        return submittedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operationId() == null) ? 0 : operationId().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((submittedDate() == null) ? 0 : submittedDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary) obj;
        if (other.operationId() == null ^ this.operationId() == null) {
            return false;
        }
        if (other.operationId() != null && !other.operationId().equals(this.operationId())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.submittedDate() == null ^ this.submittedDate() == null) {
            return false;
        }
        if (other.submittedDate() != null && !other.submittedDate().equals(this.submittedDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (submittedDate() != null) {
            sb.append("SubmittedDate: ").append(submittedDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "SubmittedDate":
            return Optional.of(clazz.cast(submittedDate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OperationSummary> {
        /**
         * <p>
         * Identifier returned to track the requested action.
         * </p>
         * 
         * @param operationId
         *        Identifier returned to track the requested action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Type of the action requested.
         * </p>
         * 
         * @param type
         *        Type of the action requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the action requested.
         * </p>
         * 
         * @param type
         *        Type of the action requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The date when the request was submitted.
         * </p>
         * 
         * @param submittedDate
         *        The date when the request was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedDate(Instant submittedDate);
    }

    static final class BuilderImpl implements Builder {
        private String operationId;

        private String status;

        private String type;

        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            operationId(model.operationId);
            status(model.status);
            type(model.type);
            submittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getSubmittedDate() {
            return submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        @Override
        public OperationSummary build() {
            return new OperationSummary(this);
        }
    }
}
