/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RegisterDomain request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RegisterDomainRequest.Builder, RegisterDomainRequest> {
    private final String domainName;

    private final String idnLangCode;

    private final Integer durationInYears;

    private final Boolean autoRenew;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private final Boolean privacyProtectAdminContact;

    private final Boolean privacyProtectRegistrantContact;

    private final Boolean privacyProtectTechContact;

    private RegisterDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
        this.durationInYears = builder.durationInYears;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.privacyProtectAdminContact = builder.privacyProtectAdminContact;
        this.privacyProtectRegistrantContact = builder.privacyProtectRegistrantContact;
        this.privacyProtectTechContact = builder.privacyProtectTechContact;
    }

    /**
     * <p>
     * The domain name that you want to register.
     * </p>
     * <p>
     * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-).
     * Internationalized Domain Names are not supported.
     * </p>
     * 
     * @return The domain name that you want to register.</p>
     *         <p>
     *         Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
     *         hyphen (-). Internationalized Domain Names are not supported.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String idnLangCode() {
        return idnLangCode;
    }

    /**
     * <p>
     * The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
     * The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of years that you want to register the domain for. Domains are registered for a minimum of one
     *         year. The maximum period depends on the top-level domain. For the range of valid values for your domain,
     *         see <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains
     *         that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         Default: 1
     */
    public Integer durationInYears() {
        return durationInYears;
    }

    /**
     * <p>
     * Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>).
     * Autorenewal only takes effect after the account is charged.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>
     *         ). Autorenewal only takes effect after the account is charged.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail techContact() {
        return techContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privacyProtectAdminContact() {
        return privacyProtectAdminContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privacyProtectRegistrantContact() {
        return privacyProtectRegistrantContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privacyProtectTechContact() {
        return privacyProtectTechContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((idnLangCode() == null) ? 0 : idnLangCode().hashCode());
        hashCode = 31 * hashCode + ((durationInYears() == null) ? 0 : durationInYears().hashCode());
        hashCode = 31 * hashCode + ((autoRenew() == null) ? 0 : autoRenew().hashCode());
        hashCode = 31 * hashCode + ((adminContact() == null) ? 0 : adminContact().hashCode());
        hashCode = 31 * hashCode + ((registrantContact() == null) ? 0 : registrantContact().hashCode());
        hashCode = 31 * hashCode + ((techContact() == null) ? 0 : techContact().hashCode());
        hashCode = 31 * hashCode + ((privacyProtectAdminContact() == null) ? 0 : privacyProtectAdminContact().hashCode());
        hashCode = 31 * hashCode
                + ((privacyProtectRegistrantContact() == null) ? 0 : privacyProtectRegistrantContact().hashCode());
        hashCode = 31 * hashCode + ((privacyProtectTechContact() == null) ? 0 : privacyProtectTechContact().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.idnLangCode() == null ^ this.idnLangCode() == null) {
            return false;
        }
        if (other.idnLangCode() != null && !other.idnLangCode().equals(this.idnLangCode())) {
            return false;
        }
        if (other.durationInYears() == null ^ this.durationInYears() == null) {
            return false;
        }
        if (other.durationInYears() != null && !other.durationInYears().equals(this.durationInYears())) {
            return false;
        }
        if (other.autoRenew() == null ^ this.autoRenew() == null) {
            return false;
        }
        if (other.autoRenew() != null && !other.autoRenew().equals(this.autoRenew())) {
            return false;
        }
        if (other.adminContact() == null ^ this.adminContact() == null) {
            return false;
        }
        if (other.adminContact() != null && !other.adminContact().equals(this.adminContact())) {
            return false;
        }
        if (other.registrantContact() == null ^ this.registrantContact() == null) {
            return false;
        }
        if (other.registrantContact() != null && !other.registrantContact().equals(this.registrantContact())) {
            return false;
        }
        if (other.techContact() == null ^ this.techContact() == null) {
            return false;
        }
        if (other.techContact() != null && !other.techContact().equals(this.techContact())) {
            return false;
        }
        if (other.privacyProtectAdminContact() == null ^ this.privacyProtectAdminContact() == null) {
            return false;
        }
        if (other.privacyProtectAdminContact() != null
                && !other.privacyProtectAdminContact().equals(this.privacyProtectAdminContact())) {
            return false;
        }
        if (other.privacyProtectRegistrantContact() == null ^ this.privacyProtectRegistrantContact() == null) {
            return false;
        }
        if (other.privacyProtectRegistrantContact() != null
                && !other.privacyProtectRegistrantContact().equals(this.privacyProtectRegistrantContact())) {
            return false;
        }
        if (other.privacyProtectTechContact() == null ^ this.privacyProtectTechContact() == null) {
            return false;
        }
        if (other.privacyProtectTechContact() != null
                && !other.privacyProtectTechContact().equals(this.privacyProtectTechContact())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (idnLangCode() != null) {
            sb.append("IdnLangCode: ").append(idnLangCode()).append(",");
        }
        if (durationInYears() != null) {
            sb.append("DurationInYears: ").append(durationInYears()).append(",");
        }
        if (autoRenew() != null) {
            sb.append("AutoRenew: ").append(autoRenew()).append(",");
        }
        if (adminContact() != null) {
            sb.append("AdminContact: ").append(adminContact()).append(",");
        }
        if (registrantContact() != null) {
            sb.append("RegistrantContact: ").append(registrantContact()).append(",");
        }
        if (techContact() != null) {
            sb.append("TechContact: ").append(techContact()).append(",");
        }
        if (privacyProtectAdminContact() != null) {
            sb.append("PrivacyProtectAdminContact: ").append(privacyProtectAdminContact()).append(",");
        }
        if (privacyProtectRegistrantContact() != null) {
            sb.append("PrivacyProtectRegistrantContact: ").append(privacyProtectRegistrantContact()).append(",");
        }
        if (privacyProtectTechContact() != null) {
            sb.append("PrivacyProtectTechContact: ").append(privacyProtectTechContact()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "IdnLangCode":
            return Optional.of(clazz.cast(idnLangCode()));
        case "DurationInYears":
            return Optional.of(clazz.cast(durationInYears()));
        case "AutoRenew":
            return Optional.of(clazz.cast(autoRenew()));
        case "AdminContact":
            return Optional.of(clazz.cast(adminContact()));
        case "RegistrantContact":
            return Optional.of(clazz.cast(registrantContact()));
        case "TechContact":
            return Optional.of(clazz.cast(techContact()));
        case "PrivacyProtectAdminContact":
            return Optional.of(clazz.cast(privacyProtectAdminContact()));
        case "PrivacyProtectRegistrantContact":
            return Optional.of(clazz.cast(privacyProtectRegistrantContact()));
        case "PrivacyProtectTechContact":
            return Optional.of(clazz.cast(privacyProtectTechContact()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterDomainRequest> {
        /**
         * <p>
         * The domain name that you want to register.
         * </p>
         * <p>
         * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen
         * (-). Internationalized Domain Names are not supported.
         * </p>
         * 
         * @param domainName
         *        The domain name that you want to register.</p>
         *        <p>
         *        Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
         *        hyphen (-). Internationalized Domain Names are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param idnLangCode
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idnLangCode(String idnLangCode);

        /**
         * <p>
         * The number of years that you want to register the domain for. Domains are registered for a minimum of one
         * year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see
         * <a href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
         * Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param durationInYears
         *        The number of years that you want to register the domain for. Domains are registered for a minimum of
         *        one year. The maximum period depends on the top-level domain. For the range of valid values for your
         *        domain, see <a
         *        href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInYears(Integer durationInYears);

        /**
         * <p>
         * Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>).
         * Autorenewal only takes effect after the account is charged.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param autoRenew
         *        Indicates whether the domain will be automatically renewed (<code>true</code>) or not (
         *        <code>false</code>). Autorenewal only takes effect after the account is charged.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param adminContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param registrantContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param techContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectAdminContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectRegistrantContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectTechContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectTechContact(Boolean privacyProtectTechContact);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String idnLangCode;

        private Integer durationInYears;

        private Boolean autoRenew;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private Boolean privacyProtectAdminContact;

        private Boolean privacyProtectRegistrantContact;

        private Boolean privacyProtectTechContact;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            domainName(model.domainName);
            idnLangCode(model.idnLangCode);
            durationInYears(model.durationInYears);
            autoRenew(model.autoRenew);
            adminContact(model.adminContact);
            registrantContact(model.registrantContact);
            techContact(model.techContact);
            privacyProtectAdminContact(model.privacyProtectAdminContact);
            privacyProtectRegistrantContact(model.privacyProtectRegistrantContact);
            privacyProtectTechContact(model.privacyProtectTechContact);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        public final Integer getDurationInYears() {
            return durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return adminContact != null ? adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return registrantContact != null ? registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return techContact != null ? techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getPrivacyProtectAdminContact() {
            return privacyProtectAdminContact;
        }

        @Override
        public final Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
            return this;
        }

        public final void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
        }

        public final Boolean getPrivacyProtectRegistrantContact() {
            return privacyProtectRegistrantContact;
        }

        @Override
        public final Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
            return this;
        }

        public final void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
        }

        public final Boolean getPrivacyProtectTechContact() {
            return privacyProtectTechContact;
        }

        @Override
        public final Builder privacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
            return this;
        }

        public final void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }
    }
}
