/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ResendContactReachabilityEmailResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ResendContactReachabilityEmailResponse.Builder, ResendContactReachabilityEmailResponse> {
    private final String domainName;

    private final String emailAddress;

    private final Boolean isAlreadyVerified;

    private ResendContactReachabilityEmailResponse(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.emailAddress = builder.emailAddress;
        this.isAlreadyVerified = builder.isAlreadyVerified;
    }

    /**
     * <p>
     * The domain name for which you requested a confirmation email.
     * </p>
     * 
     * @return The domain name for which you requested a confirmation email.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The email address for the registrant contact at the time that we sent the verification email.
     * </p>
     * 
     * @return The email address for the registrant contact at the time that we sent the verification email.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * <code>True</code> if the email address for the registrant contact has already been verified, and
     * <code>false</code> otherwise. If the email address has already been verified, we don't send another confirmation
     * email.
     * </p>
     * 
     * @return <code>True</code> if the email address for the registrant contact has already been verified, and
     *         <code>false</code> otherwise. If the email address has already been verified, we don't send another
     *         confirmation email.
     */
    public Boolean isAlreadyVerified() {
        return isAlreadyVerified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((emailAddress() == null) ? 0 : emailAddress().hashCode());
        hashCode = 31 * hashCode + ((isAlreadyVerified() == null) ? 0 : isAlreadyVerified().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendContactReachabilityEmailResponse)) {
            return false;
        }
        ResendContactReachabilityEmailResponse other = (ResendContactReachabilityEmailResponse) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.emailAddress() == null ^ this.emailAddress() == null) {
            return false;
        }
        if (other.emailAddress() != null && !other.emailAddress().equals(this.emailAddress())) {
            return false;
        }
        if (other.isAlreadyVerified() == null ^ this.isAlreadyVerified() == null) {
            return false;
        }
        if (other.isAlreadyVerified() != null && !other.isAlreadyVerified().equals(this.isAlreadyVerified())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (emailAddress() != null) {
            sb.append("EmailAddress: ").append(emailAddress()).append(",");
        }
        if (isAlreadyVerified() != null) {
            sb.append("IsAlreadyVerified: ").append(isAlreadyVerified()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.of(clazz.cast(domainName()));
        case "emailAddress":
            return Optional.of(clazz.cast(emailAddress()));
        case "isAlreadyVerified":
            return Optional.of(clazz.cast(isAlreadyVerified()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ResendContactReachabilityEmailResponse> {
        /**
         * <p>
         * The domain name for which you requested a confirmation email.
         * </p>
         * 
         * @param domainName
         *        The domain name for which you requested a confirmation email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The email address for the registrant contact at the time that we sent the verification email.
         * </p>
         * 
         * @param emailAddress
         *        The email address for the registrant contact at the time that we sent the verification email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * <code>True</code> if the email address for the registrant contact has already been verified, and
         * <code>false</code> otherwise. If the email address has already been verified, we don't send another
         * confirmation email.
         * </p>
         * 
         * @param isAlreadyVerified
         *        <code>True</code> if the email address for the registrant contact has already been verified, and
         *        <code>false</code> otherwise. If the email address has already been verified, we don't send another
         *        confirmation email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAlreadyVerified(Boolean isAlreadyVerified);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String emailAddress;

        private Boolean isAlreadyVerified;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendContactReachabilityEmailResponse model) {
            domainName(model.domainName);
            emailAddress(model.emailAddress);
            isAlreadyVerified(model.isAlreadyVerified);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final Boolean getIsAlreadyVerified() {
            return isAlreadyVerified;
        }

        @Override
        public final Builder isAlreadyVerified(Boolean isAlreadyVerified) {
            this.isAlreadyVerified = isAlreadyVerified;
            return this;
        }

        public final void setIsAlreadyVerified(Boolean isAlreadyVerified) {
            this.isAlreadyVerified = isAlreadyVerified;
        }

        @Override
        public ResendContactReachabilityEmailResponse build() {
            return new ResendContactReachabilityEmailResponse(this);
        }
    }
}
