/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateDomainContactPrivacy request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainContactPrivacyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDomainContactPrivacyRequest.Builder, UpdateDomainContactPrivacyRequest> {
    private final String domainName;

    private final Boolean adminPrivacy;

    private final Boolean registrantPrivacy;

    private final Boolean techPrivacy;

    private UpdateDomainContactPrivacyRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
    }

    /**
     * <p>
     * The name of the domain that you want to update the privacy setting for.
     * </p>
     * 
     * @return The name of the domain that you want to update the privacy setting for.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.
     */
    public Boolean adminPrivacy() {
        return adminPrivacy;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.
     */
    public Boolean registrantPrivacy() {
        return registrantPrivacy;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.
     */
    public Boolean techPrivacy() {
        return techPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((adminPrivacy() == null) ? 0 : adminPrivacy().hashCode());
        hashCode = 31 * hashCode + ((registrantPrivacy() == null) ? 0 : registrantPrivacy().hashCode());
        hashCode = 31 * hashCode + ((techPrivacy() == null) ? 0 : techPrivacy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactPrivacyRequest)) {
            return false;
        }
        UpdateDomainContactPrivacyRequest other = (UpdateDomainContactPrivacyRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.adminPrivacy() == null ^ this.adminPrivacy() == null) {
            return false;
        }
        if (other.adminPrivacy() != null && !other.adminPrivacy().equals(this.adminPrivacy())) {
            return false;
        }
        if (other.registrantPrivacy() == null ^ this.registrantPrivacy() == null) {
            return false;
        }
        if (other.registrantPrivacy() != null && !other.registrantPrivacy().equals(this.registrantPrivacy())) {
            return false;
        }
        if (other.techPrivacy() == null ^ this.techPrivacy() == null) {
            return false;
        }
        if (other.techPrivacy() != null && !other.techPrivacy().equals(this.techPrivacy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (adminPrivacy() != null) {
            sb.append("AdminPrivacy: ").append(adminPrivacy()).append(",");
        }
        if (registrantPrivacy() != null) {
            sb.append("RegistrantPrivacy: ").append(registrantPrivacy()).append(",");
        }
        if (techPrivacy() != null) {
            sb.append("TechPrivacy: ").append(techPrivacy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "AdminPrivacy":
            return Optional.of(clazz.cast(adminPrivacy()));
        case "RegistrantPrivacy":
            return Optional.of(clazz.cast(registrantPrivacy()));
        case "TechPrivacy":
            return Optional.of(clazz.cast(techPrivacy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
        /**
         * <p>
         * The name of the domain that you want to update the privacy setting for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to update the privacy setting for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * 
         * @param adminPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPrivacy(Boolean adminPrivacy);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * 
         * @param registrantPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantPrivacy(Boolean registrantPrivacy);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * 
         * @param techPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techPrivacy(Boolean techPrivacy);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private Boolean adminPrivacy;

        private Boolean registrantPrivacy;

        private Boolean techPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactPrivacyRequest model) {
            domainName(model.domainName);
            adminPrivacy(model.adminPrivacy);
            registrantPrivacy(model.registrantPrivacy);
            techPrivacy(model.techPrivacy);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAdminPrivacy() {
            return adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        @Override
        public UpdateDomainContactPrivacyRequest build() {
            return new UpdateDomainContactPrivacyRequest(this);
        }
    }
}
