/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisassociateVPCFromHostedZoneRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisassociateVPCFromHostedZoneRequest> {
    private final String hostedZoneId;
    private final VPC vpc;
    private final String comment;

    private DisassociateVPCFromHostedZoneRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
        this.comment = builder.comment;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public VPC vpc() {
        return this.vpc;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.vpc() == null ? 0 : this.vpc().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateVPCFromHostedZoneRequest)) {
            return false;
        }
        DisassociateVPCFromHostedZoneRequest other = (DisassociateVPCFromHostedZoneRequest)((Object)obj);
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        return other.comment() == null || other.comment().equals(this.comment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.vpc() != null) {
            sb.append("VPC: ").append(this.vpc()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "VPC": {
                return Optional.of(clazz.cast(this.vpc()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private VPC vpc;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateVPCFromHostedZoneRequest model) {
            this.hostedZoneId(model.hostedZoneId);
            this.vpc(model.vpc);
            this.comment(model.comment);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC.Builder getVPC() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public DisassociateVPCFromHostedZoneRequest build() {
            return new DisassociateVPCFromHostedZoneRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisassociateVPCFromHostedZoneRequest> {
        public Builder hostedZoneId(String var1);

        public Builder vpc(VPC var1);

        public Builder comment(String var1);
    }
}

