/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GeoLocation
implements ToCopyableBuilder<Builder, GeoLocation> {
    private final String continentCode;
    private final String countryCode;
    private final String subdivisionCode;

    private GeoLocation(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    public String continentCode() {
        return this.continentCode;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public String subdivisionCode() {
        return this.subdivisionCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.continentCode() == null ? 0 : this.continentCode().hashCode());
        hashCode = 31 * hashCode + (this.countryCode() == null ? 0 : this.countryCode().hashCode());
        hashCode = 31 * hashCode + (this.subdivisionCode() == null ? 0 : this.subdivisionCode().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)obj;
        if (other.continentCode() == null ^ this.continentCode() == null) {
            return false;
        }
        if (other.continentCode() != null && !other.continentCode().equals(this.continentCode())) {
            return false;
        }
        if (other.countryCode() == null ^ this.countryCode() == null) {
            return false;
        }
        if (other.countryCode() != null && !other.countryCode().equals(this.countryCode())) {
            return false;
        }
        if (other.subdivisionCode() == null ^ this.subdivisionCode() == null) {
            return false;
        }
        return other.subdivisionCode() == null || other.subdivisionCode().equals(this.subdivisionCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.continentCode() != null) {
            sb.append("ContinentCode: ").append(this.continentCode()).append(",");
        }
        if (this.countryCode() != null) {
            sb.append("CountryCode: ").append(this.countryCode()).append(",");
        }
        if (this.subdivisionCode() != null) {
            sb.append("SubdivisionCode: ").append(this.subdivisionCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinentCode": {
                return Optional.of(clazz.cast(this.continentCode()));
            }
            case "CountryCode": {
                return Optional.of(clazz.cast(this.countryCode()));
            }
            case "SubdivisionCode": {
                return Optional.of(clazz.cast(this.subdivisionCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String continentCode;
        private String countryCode;
        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocation model) {
            this.continentCode(model.continentCode);
            this.countryCode(model.countryCode);
            this.subdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return this.continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getSubdivisionCode() {
            return this.subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GeoLocation> {
        public Builder continentCode(String var1);

        public Builder countryCode(String var1);

        public Builder subdivisionCode(String var1);
    }
}

