/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.services.route53domains.transform.BillingRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BillingRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, BillingRecord> {
    private final String domainName;
    private final String operation;
    private final String invoiceId;
    private final Instant billDate;
    private final Double price;

    private BillingRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.operation = builder.operation;
        this.invoiceId = builder.invoiceId;
        this.billDate = builder.billDate;
        this.price = builder.price;
    }

    public String domainName() {
        return this.domainName;
    }

    public OperationType operation() {
        return OperationType.fromValue(this.operation);
    }

    public String operationString() {
        return this.operation;
    }

    public String invoiceId() {
        return this.invoiceId;
    }

    public Instant billDate() {
        return this.billDate;
    }

    public Double price() {
        return this.price;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.operationString() == null ? 0 : this.operationString().hashCode());
        hashCode = 31 * hashCode + (this.invoiceId() == null ? 0 : this.invoiceId().hashCode());
        hashCode = 31 * hashCode + (this.billDate() == null ? 0 : this.billDate().hashCode());
        hashCode = 31 * hashCode + (this.price() == null ? 0 : this.price().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord)obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.operationString() == null ^ this.operationString() == null) {
            return false;
        }
        if (other.operationString() != null && !other.operationString().equals(this.operationString())) {
            return false;
        }
        if (other.invoiceId() == null ^ this.invoiceId() == null) {
            return false;
        }
        if (other.invoiceId() != null && !other.invoiceId().equals(this.invoiceId())) {
            return false;
        }
        if (other.billDate() == null ^ this.billDate() == null) {
            return false;
        }
        if (other.billDate() != null && !other.billDate().equals(this.billDate())) {
            return false;
        }
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        return other.price() == null || other.price().equals(this.price());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.operationString() != null) {
            sb.append("Operation: ").append(this.operationString()).append(",");
        }
        if (this.invoiceId() != null) {
            sb.append("InvoiceId: ").append(this.invoiceId()).append(",");
        }
        if (this.billDate() != null) {
            sb.append("BillDate: ").append(this.billDate()).append(",");
        }
        if (this.price() != null) {
            sb.append("Price: ").append(this.price()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "Operation": {
                return Optional.of(clazz.cast(this.operationString()));
            }
            case "InvoiceId": {
                return Optional.of(clazz.cast(this.invoiceId()));
            }
            case "BillDate": {
                return Optional.of(clazz.cast(this.billDate()));
            }
            case "Price": {
                return Optional.of(clazz.cast(this.price()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BillingRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String operation;
        private String invoiceId;
        private Instant billDate;
        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingRecord model) {
            this.domainName(model.domainName);
            this.operation(model.operation);
            this.invoiceId(model.invoiceId);
            this.billDate(model.billDate);
            this.price(model.price);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationType operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getInvoiceId() {
            return this.invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public final Instant getBillDate() {
            return this.billDate;
        }

        @Override
        public final Builder billDate(Instant billDate) {
            this.billDate = billDate;
            return this;
        }

        public final void setBillDate(Instant billDate) {
            this.billDate = billDate;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public BillingRecord build() {
            return new BillingRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BillingRecord> {
        public Builder domainName(String var1);

        public Builder operation(String var1);

        public Builder operation(OperationType var1);

        public Builder invoiceId(String var1);

        public Builder billDate(Instant var1);

        public Builder price(Double var1);
    }
}

