/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the tags that you want to add, edit, or delete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeTagsForResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ChangeTagsForResourceRequest.Builder, ChangeTagsForResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private final List<Tag> addTags;

    private final List<String> removeTagKeys;

    private ChangeTagsForResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.addTags = builder.addTags;
        this.removeTagKeys = builder.removeTagKeys;
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TagResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public TagResourceType resourceType() {
        return TagResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TagResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of the resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource for which you want to add, change, or delete tags.
     * </p>
     * 
     * @return The ID of the resource for which you want to add, change, or delete tags.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone
     * and/or the tags that you want to edit <code>Value</code> for.
     * </p>
     * <p>
     * You can add a maximum of 10 tags to a health check or a hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the tags that you want to add to the specified health check or
     *         hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
     *         <p>
     *         You can add a maximum of 10 tags to a health check or a hosted zone.
     */
    public List<Tag> addTags() {
        return addTags;
    }

    /**
     * <p>
     * A complex type that contains a list of the tags that you want to delete from the specified health check or hosted
     * zone. You can specify up to 10 keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the tags that you want to delete from the specified health check
     *         or hosted zone. You can specify up to 10 keys.
     */
    public List<String> removeTagKeys() {
        return removeTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(addTags());
        hashCode = 31 * hashCode + Objects.hashCode(removeTagKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest) obj;
        return Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(addTags(), other.addTags())
                && Objects.equals(removeTagKeys(), other.removeTagKeys());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (addTags() != null) {
            sb.append("AddTags: ").append(addTags()).append(",");
        }
        if (removeTagKeys() != null) {
            sb.append("RemoveTagKeys: ").append(removeTagKeys()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "ResourceId":
            return Optional.of(clazz.cast(resourceId()));
        case "AddTags":
            return Optional.of(clazz.cast(addTags()));
        case "RemoveTagKeys":
            return Optional.of(clazz.cast(removeTagKeys()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeTagsForResourceRequest> {
        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(TagResourceType resourceType);

        /**
         * <p>
         * The ID of the resource for which you want to add, change, or delete tags.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource for which you want to add, change, or delete tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * 
         * @param addTags
         *        A complex type that contains a list of the tags that you want to add to the specified health check or
         *        hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
         *        <p>
         *        You can add a maximum of 10 tags to a health check or a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Collection<Tag> addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * 
         * @param addTags
         *        A complex type that contains a list of the tags that you want to add to the specified health check or
         *        hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
         *        <p>
         *        You can add a maximum of 10 tags to a health check or a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Tag... addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to delete from the specified health check or
         * hosted zone. You can specify up to 10 keys.
         * </p>
         * 
         * @param removeTagKeys
         *        A complex type that contains a list of the tags that you want to delete from the specified health
         *        check or hosted zone. You can specify up to 10 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTagKeys(Collection<String> removeTagKeys);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to delete from the specified health check or
         * hosted zone. You can specify up to 10 keys.
         * </p>
         * 
         * @param removeTagKeys
         *        A complex type that contains a list of the tags that you want to delete from the specified health
         *        check or hosted zone. You can specify up to 10 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTagKeys(String... removeTagKeys);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<Tag> addTags;

        private List<String> removeTagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeTagsForResourceRequest model) {
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            addTags(model.addTags);
            removeTagKeys(model.removeTagKeys);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return addTags != null ? addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = TagListCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTagKeys() {
            return removeTagKeys;
        }

        @Override
        public final Builder removeTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTagKeys(String... removeTagKeys) {
            removeTagKeys(Arrays.asList(removeTagKeys));
            return this;
        }

        public final void setRemoveTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
        }

        @Override
        public ChangeTagsForResourceRequest build() {
            return new ChangeTagsForResourceRequest(this);
        }
    }
}
