/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateQueryLoggingConfigResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateQueryLoggingConfigResponse.Builder, CreateQueryLoggingConfigResponse> {
    private final QueryLoggingConfig queryLoggingConfig;

    private final String location;

    private CreateQueryLoggingConfigResponse(BuilderImpl builder) {
        this.queryLoggingConfig = builder.queryLoggingConfig;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you want to
     * log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.
     * </p>
     * 
     * @return A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you
     *         want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs
     *         to.
     */
    public QueryLoggingConfig queryLoggingConfig() {
        return queryLoggingConfig;
    }

    /**
     * <p>
     * The unique URL representing the new query logging configuration.
     * </p>
     * 
     * @return The unique URL representing the new query logging configuration.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryLoggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueryLoggingConfigResponse)) {
            return false;
        }
        CreateQueryLoggingConfigResponse other = (CreateQueryLoggingConfigResponse) obj;
        return Objects.equals(queryLoggingConfig(), other.queryLoggingConfig()) && Objects.equals(location(), other.location());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (queryLoggingConfig() != null) {
            sb.append("QueryLoggingConfig: ").append(queryLoggingConfig()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryLoggingConfig":
            return Optional.of(clazz.cast(queryLoggingConfig()));
        case "Location":
            return Optional.of(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateQueryLoggingConfigResponse> {
        /**
         * <p>
         * A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you
         * want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.
         * </p>
         * 
         * @param queryLoggingConfig
         *        A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that
         *        you want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query
         *        logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLoggingConfig(QueryLoggingConfig queryLoggingConfig);

        /**
         * <p>
         * A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you
         * want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.
         * </p>
         * This is a convenience that creates an instance of the {@link QueryLoggingConfig.Builder} avoiding the need to
         * create one manually via {@link QueryLoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link QueryLoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #queryLoggingConfig(QueryLoggingConfig)}.
         * 
         * @param queryLoggingConfig
         *        a consumer that will call methods on {@link QueryLoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryLoggingConfig(QueryLoggingConfig)
         */
        default Builder queryLoggingConfig(Consumer<QueryLoggingConfig.Builder> queryLoggingConfig) {
            return queryLoggingConfig(QueryLoggingConfig.builder().apply(queryLoggingConfig).build());
        }

        /**
         * <p>
         * The unique URL representing the new query logging configuration.
         * </p>
         * 
         * @param location
         *        The unique URL representing the new query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private QueryLoggingConfig queryLoggingConfig;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueryLoggingConfigResponse model) {
            queryLoggingConfig(model.queryLoggingConfig);
            location(model.location);
        }

        public final QueryLoggingConfig.Builder getQueryLoggingConfig() {
            return queryLoggingConfig != null ? queryLoggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder queryLoggingConfig(QueryLoggingConfig queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        public final void setQueryLoggingConfig(QueryLoggingConfig.BuilderImpl queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig != null ? queryLoggingConfig.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateQueryLoggingConfigResponse build() {
            return new CreateQueryLoggingConfigResponse(this);
        }
    }
}
