/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReusableDelegationSetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateReusableDelegationSetRequest.Builder, CreateReusableDelegationSetRequest> {
    private final String callerReference;

    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * A unique string that identifies the request, and that allows you to retry failed
     * <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use
     * a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code>
     * request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request, and that allows you to retry failed
     *         <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You
     *         must use a unique <code>CallerReference</code> string every time you submit a
     *         <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string,
     *         for example a date/time stamp.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.
     * </p>
     * 
     * @return If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted
     *         zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (callerReference() != null) {
            sb.append("CallerReference: ").append(callerReference()).append(",");
        }
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        /**
         * <p>
         * A unique string that identifies the request, and that allows you to retry failed
         * <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must
         * use a unique <code>CallerReference</code> string every time you submit a
         * <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for
         * example a date/time stamp.
         * </p>
         * 
         * @param callerReference
         *        A unique string that identifies the request, and that allows you to retry failed
         *        <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice.
         *        You must use a unique <code>CallerReference</code> string every time you submit a
         *        <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique
         *        string, for example a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            callerReference(model.callerReference);
            hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }
    }
}
