/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>CreateTrafficPolicyVersion</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTrafficPolicyVersionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateTrafficPolicyVersionResponse.Builder, CreateTrafficPolicyVersionResponse> {
    private final TrafficPolicy trafficPolicy;

    private final String location;

    private CreateTrafficPolicyVersionResponse(BuilderImpl builder) {
        this.trafficPolicy = builder.trafficPolicy;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains settings for the new version of the traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the new version of the traffic policy.
     */
    public TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    /**
     * <p>
     * A unique URL that represents a new traffic policy version.
     * </p>
     * 
     * @return A unique URL that represents a new traffic policy version.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyVersionResponse)) {
            return false;
        }
        CreateTrafficPolicyVersionResponse other = (CreateTrafficPolicyVersionResponse) obj;
        return Objects.equals(trafficPolicy(), other.trafficPolicy()) && Objects.equals(location(), other.location());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (trafficPolicy() != null) {
            sb.append("TrafficPolicy: ").append(trafficPolicy()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicy":
            return Optional.of(clazz.cast(trafficPolicy()));
        case "Location":
            return Optional.of(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTrafficPolicyVersionResponse> {
        /**
         * <p>
         * A complex type that contains settings for the new version of the traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the new version of the traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);

        /**
         * <p>
         * A complex type that contains settings for the new version of the traffic policy.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicy.Builder} avoiding the need to
         * create one manually via {@link TrafficPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficPolicy(TrafficPolicy)}.
         * 
         * @param trafficPolicy
         *        a consumer that will call methods on {@link TrafficPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicy(TrafficPolicy)
         */
        default Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return trafficPolicy(TrafficPolicy.builder().apply(trafficPolicy).build());
        }

        /**
         * <p>
         * A unique URL that represents a new traffic policy version.
         * </p>
         * 
         * @param location
         *        A unique URL that represents a new traffic policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyVersionResponse model) {
            trafficPolicy(model.trafficPolicy);
            location(model.location);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return trafficPolicy != null ? trafficPolicy.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyVersionResponse build() {
            return new CreateTrafficPolicyVersionResponse(this);
        }
    }
}
