/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for a GetChange request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetChangeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetChangeRequest.Builder, GetChangeRequest> {
    private final String id;

    private GetChangeRequest(BuilderImpl builder) {
        this.id = builder.id;
    }

    /**
     * <p>
     * The ID of the change batch request. The value that you specify here is the value that
     * <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.
     * </p>
     * 
     * @return The ID of the change batch request. The value that you specify here is the value that
     *         <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the
     *         request.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChangeRequest)) {
            return false;
        }
        GetChangeRequest other = (GetChangeRequest) obj;
        return Objects.equals(id(), other.id());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetChangeRequest> {
        /**
         * <p>
         * The ID of the change batch request. The value that you specify here is the value that
         * <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.
         * </p>
         * 
         * @param id
         *        The ID of the change batch request. The value that you specify here is the value that
         *        <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChangeRequest model) {
            id(model.id);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public GetChangeRequest build() {
            return new GetChangeRequest(this);
        }
    }
}
