/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheckLastFailureReason</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHealthCheckLastFailureReasonResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetHealthCheckLastFailureReasonResponse.Builder, GetHealthCheckLastFailureReasonResponse> {
    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckLastFailureReasonResponse(BuilderImpl builder) {
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    /**
     * <p>
     * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
     * reporting a last failure reason.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
     *         reporting a last failure reason.
     */
    public List<HealthCheckObservation> healthCheckObservations() {
        return healthCheckObservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckObservations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckLastFailureReasonResponse)) {
            return false;
        }
        GetHealthCheckLastFailureReasonResponse other = (GetHealthCheckLastFailureReasonResponse) obj;
        return Objects.equals(healthCheckObservations(), other.healthCheckObservations());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (healthCheckObservations() != null) {
            sb.append("HealthCheckObservations: ").append(healthCheckObservations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckObservations":
            return Optional.of(clazz.cast(healthCheckObservations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetHealthCheckLastFailureReasonResponse> {
        /**
         * <p>
         * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
         * reporting a last failure reason.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that
         *        is reporting a last failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is
         * reporting a last failure reason.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that
         *        is reporting a last failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations);
    }

    static final class BuilderImpl implements Builder {
        private List<HealthCheckObservation> healthCheckObservations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckLastFailureReasonResponse model) {
            healthCheckObservations(model.healthCheckObservations);
        }

        public final Collection<HealthCheckObservation.Builder> getHealthCheckObservations() {
            return healthCheckObservations != null ? healthCheckObservations.stream().map(HealthCheckObservation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations) {
            healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation.BuilderImpl> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copyFromBuilder(healthCheckObservations);
        }

        @Override
        public GetHealthCheckLastFailureReasonResponse build() {
            return new GetHealthCheckLastFailureReasonResponse(this);
        }
    }
}
