/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets information about a specific traffic policy version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTrafficPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetTrafficPolicyRequest.Builder, GetTrafficPolicyRequest> {
    private final String id;

    private final Integer version;

    private GetTrafficPolicyRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the traffic policy that you want to get information about.
     * </p>
     * 
     * @return The ID of the traffic policy that you want to get information about.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The version number of the traffic policy that you want to get information about.
     * </p>
     * 
     * @return The version number of the traffic policy that you want to get information about.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyRequest)) {
            return false;
        }
        GetTrafficPolicyRequest other = (GetTrafficPolicyRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Version":
            return Optional.of(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetTrafficPolicyRequest> {
        /**
         * <p>
         * The ID of the traffic policy that you want to get information about.
         * </p>
         * 
         * @param id
         *        The ID of the traffic policy that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version number of the traffic policy that you want to get information about.
         * </p>
         * 
         * @param version
         *        The version number of the traffic policy that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyRequest model) {
            id(model.id);
            version(model.version);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public GetTrafficPolicyRequest build() {
            return new GetTrafficPolicyRequest(this);
        }
    }
}
