/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains an optional comment about your hosted zone. If you don't want to specify a comment, omit
 * both the <code>HostedZoneConfig</code> and <code>Comment</code> elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostedZoneConfig implements ToCopyableBuilder<HostedZoneConfig.Builder, HostedZoneConfig> {
    private final String comment;

    private final Boolean privateZone;

    private HostedZoneConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.privateZone = builder.privateZone;
    }

    /**
     * <p>
     * Any comments that you want to include about the hosted zone.
     * </p>
     * 
     * @return Any comments that you want to include about the hosted zone.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * A value that indicates whether this is a private hosted zone.
     * </p>
     * 
     * @return A value that indicates whether this is a private hosted zone.
     */
    public Boolean privateZone() {
        return privateZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(privateZone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneConfig)) {
            return false;
        }
        HostedZoneConfig other = (HostedZoneConfig) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(privateZone(), other.privateZone());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (privateZone() != null) {
            sb.append("PrivateZone: ").append(privateZone()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "PrivateZone":
            return Optional.of(clazz.cast(privateZone()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostedZoneConfig> {
        /**
         * <p>
         * Any comments that you want to include about the hosted zone.
         * </p>
         * 
         * @param comment
         *        Any comments that you want to include about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A value that indicates whether this is a private hosted zone.
         * </p>
         * 
         * @param privateZone
         *        A value that indicates whether this is a private hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateZone(Boolean privateZone);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private Boolean privateZone;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneConfig model) {
            comment(model.comment);
            privateZone(model.privateZone);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Boolean getPrivateZone() {
            return privateZone;
        }

        @Override
        public final Builder privateZone(Boolean privateZone) {
            this.privateZone = privateZone;
            return this;
        }

        public final void setPrivateZone(Boolean privateZone) {
            this.privateZone = privateZone;
        }

        @Override
        public HostedZoneConfig build() {
            return new HostedZoneConfig(this);
        }
    }
}
