/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This operation can't be completed either because the current account has reached the limit on reusable delegation
 * sets that it can create or because you've reached the limit on the number of Amazon VPCs that you can associate with
 * a private hosted zone. To get the current limit on the number of reusable delegation sets, see
 * <a>GetAccountLimit</a>. To get the current limit on the number of Amazon VPCs that you can associate with a private
 * hosted zone, see <a>GetHostedZoneLimit</a>. To request a higher limit, <a
 * href="http://aws.amazon.com/route53-request">create a case</a> with the AWS Support Center.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LimitsExceededException extends Route53Exception implements
        ToCopyableBuilder<LimitsExceededException.Builder, LimitsExceededException> {
    private LimitsExceededException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, LimitsExceededException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitsExceededException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public LimitsExceededException build() {
            return new LimitsExceededException(this);
        }
    }
}
