/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get a list of the reusable delegation sets that are associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListReusableDelegationSetsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListReusableDelegationSetsRequest.Builder, ListReusableDelegationSetsRequest> {
    private final String marker;

    private final String maxItems;

    private ListReusableDelegationSetsRequest(BuilderImpl builder) {
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable
     * delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request.
     * </p>
     * <p>
     * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
     * which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another
     * request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * reusable delegation sets to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code>
     *         request. </p>
     *         <p>
     *         For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
     *         response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you
     *         submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more reusable delegation sets to get.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request.
     * If you specify a value greater than 100, Amazon Route 53 returns only the first 100 reusable delegation sets.
     * </p>
     * 
     * @return The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this
     *         request. If you specify a value greater than 100, Amazon Route 53 returns only the first 100 reusable
     *         delegation sets.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReusableDelegationSetsRequest)) {
            return false;
        }
        ListReusableDelegationSetsRequest other = (ListReusableDelegationSetsRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListReusableDelegationSetsRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code>
         * request.
         * </p>
         * <p>
         * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         * response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit
         * another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * reusable delegation sets to get.
         * </p>
         * 
         * @param marker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code>
         *        request. </p>
         *        <p>
         *        For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         *        response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you
         *        submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more reusable delegation sets to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this
         * request. If you specify a value greater than 100, Amazon Route 53 returns only the first 100 reusable
         * delegation sets.
         * </p>
         * 
         * @param maxItems
         *        The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this
         *        request. If you specify a value greater than 100, Amazon Route 53 returns only the first 100 reusable
         *        delegation sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReusableDelegationSetsRequest model) {
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListReusableDelegationSetsRequest build() {
            return new ListReusableDelegationSetsRequest(this);
        }
    }
}
