/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the information about the request to list the traffic policies that are associated with
 * the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPoliciesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTrafficPoliciesRequest.Builder, ListTrafficPoliciesRequest> {
    private final String trafficPolicyIdMarker;

    private final String maxItems;

    private ListTrafficPoliciesRequest(BuilderImpl builder) {
        this.trafficPolicyIdMarker = builder.trafficPolicyIdMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
     * <code>TrafficPolicyIdMarker</code> parameter.
     * </p>
     * <p>
     * If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code>
     * returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another
     * request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the
     * value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.
     * </p>
     * 
     * @return (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
     *         <code>TrafficPolicyIdMarker</code> parameter.</p>
     *         <p>
     *         If you have more traffic policies than the value of <code>MaxItems</code>,
     *         <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get
     *         the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of
     *         <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was
     *         returned in the previous response.
     */
    public String trafficPolicyIdMarker() {
        return trafficPolicyIdMarker;
    }

    /**
     * <p>
     * (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this
     * request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in
     * the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first
     * traffic policy that Amazon Route 53 will return if you submit another request.
     * </p>
     * 
     * @return (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to
     *         this request. If you have more than <code>MaxItems</code> traffic policies, the value of
     *         <code>IsTruncated</code> in the response is <code>true</code>, and the value of
     *         <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Amazon Route 53 will return
     *         if you submit another request.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesRequest)) {
            return false;
        }
        ListTrafficPoliciesRequest other = (ListTrafficPoliciesRequest) obj;
        return Objects.equals(trafficPolicyIdMarker(), other.trafficPolicyIdMarker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (trafficPolicyIdMarker() != null) {
            sb.append("TrafficPolicyIdMarker: ").append(trafficPolicyIdMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyIdMarker":
            return Optional.of(clazz.cast(trafficPolicyIdMarker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTrafficPoliciesRequest> {
        /**
         * <p>
         * (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
         * <code>TrafficPolicyIdMarker</code> parameter.
         * </p>
         * <p>
         * If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code>
         * returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit
         * another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>,
         * specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.
         * </p>
         * 
         * @param trafficPolicyIdMarker
         *        (Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the
         *        <code>TrafficPolicyIdMarker</code> parameter.</p>
         *        <p>
         *        If you have more traffic policies than the value of <code>MaxItems</code>,
         *        <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get
         *        the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value
         *        of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that
         *        was returned in the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyIdMarker(String trafficPolicyIdMarker);

        /**
         * <p>
         * (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this
         * request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code>
         * in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the
         * first traffic policy that Amazon Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response
         *        to this request. If you have more than <code>MaxItems</code> traffic policies, the value of
         *        <code>IsTruncated</code> in the response is <code>true</code>, and the value of
         *        <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Amazon Route 53 will
         *        return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl implements Builder {
        private String trafficPolicyIdMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesRequest model) {
            trafficPolicyIdMarker(model.trafficPolicyIdMarker);
            maxItems(model.maxItems);
        }

        public final String getTrafficPolicyIdMarker() {
            return trafficPolicyIdMarker;
        }

        @Override
        public final Builder trafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
            return this;
        }

        public final void setTrafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPoliciesRequest build() {
            return new ListTrafficPoliciesRequest(this);
        }
    }
}
