/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about that can be associated with your hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListVPCAssociationAuthorizationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListVPCAssociationAuthorizationsRequest.Builder, ListVPCAssociationAuthorizationsRequest> {
    private final String hostedZoneId;

    private final String nextToken;

    private final String maxResults;

    private ListVPCAssociationAuthorizationsRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
     * </p>
     * 
     * @return The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be
     * associated with the specified hosted zone. To get the next page of results, submit another request, and include
     * the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another
     * <code>ListVPCAssociationAuthorizations</code> request.
     * </p>
     * 
     * @return <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be
     *         associated with the specified hosted zone. To get the next page of results, submit another request, and
     *         include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in
     *         another <code>ListVPCAssociationAuthorizations</code> request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If
     * you don't specify a value for <code>MaxResults</code>, Amazon Route 53 returns up to 50 VPCs per page.
     * </p>
     * 
     * @return <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to
     *         return. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53 returns up to 50 VPCs
     *         per page.
     */
    public String maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVPCAssociationAuthorizationsRequest)) {
            return false;
        }
        ListVPCAssociationAuthorizationsRequest other = (ListVPCAssociationAuthorizationsRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListVPCAssociationAuthorizationsRequest> {
        /**
         * <p>
         * The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be
         * associated with the specified hosted zone. To get the next page of results, submit another request, and
         * include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in
         * another <code>ListVPCAssociationAuthorizations</code> request.
         * </p>
         * 
         * @param nextToken
         *        <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can
         *        be associated with the specified hosted zone. To get the next page of results, submit another request,
         *        and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code>
         *        parameter in another <code>ListVPCAssociationAuthorizations</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to
         * return. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53 returns up to 50 VPCs per
         * page.
         * </p>
         * 
         * @param maxResults
         *        <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to
         *        return. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53 returns up to 50
         *        VPCs per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(String maxResults);
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String nextToken;

        private String maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVPCAssociationAuthorizationsRequest model) {
            hostedZoneId(model.hostedZoneId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public ListVPCAssociationAuthorizationsRequest build() {
            return new ListVPCAssociationAuthorizationsRequest(this);
        }
    }
}
