/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListVPCAssociationAuthorizationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListVPCAssociationAuthorizationsResponse.Builder, ListVPCAssociationAuthorizationsResponse> {
    private final String hostedZoneId;

    private final String nextToken;

    private final List<VPC> vpCs;

    private ListVPCAssociationAuthorizationsResponse(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.vpCs = builder.vpCs;
    }

    /**
     * <p>
     * The ID of the hosted zone that you can associate the listed VPCs with.
     * </p>
     * 
     * @return The ID of the hosted zone that you can associate the listed VPCs with.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the
     * specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code>
     * request, and include the value of the <code>NextToken</code> element from the response in the
     * <code>nexttoken</code> request parameter.
     * </p>
     * 
     * @return When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated
     *         with the specified hosted zone. To get the next page of VPCs, submit another
     *         <code>ListVPCAssociationAuthorizations</code> request, and include the value of the
     *         <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The list of VPCs that are authorized to be associated with the specified hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of VPCs that are authorized to be associated with the specified hosted zone.
     */
    public List<VPC> vpCs() {
        return vpCs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(vpCs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVPCAssociationAuthorizationsResponse)) {
            return false;
        }
        ListVPCAssociationAuthorizationsResponse other = (ListVPCAssociationAuthorizationsResponse) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(vpCs(), other.vpCs());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (vpCs() != null) {
            sb.append("VPCs: ").append(vpCs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "VPCs":
            return Optional.of(clazz.cast(vpCs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListVPCAssociationAuthorizationsResponse> {
        /**
         * <p>
         * The ID of the hosted zone that you can associate the listed VPCs with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you can associate the listed VPCs with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with
         * the specified hosted zone. To get the next page of VPCs, submit another
         * <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code>
         * element from the response in the <code>nexttoken</code> request parameter.
         * </p>
         * 
         * @param nextToken
         *        When the response includes a <code>NextToken</code> element, there are more VPCs that can be
         *        associated with the specified hosted zone. To get the next page of VPCs, submit another
         *        <code>ListVPCAssociationAuthorizations</code> request, and include the value of the
         *        <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        The list of VPCs that are authorized to be associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(Collection<VPC> vpCs);

        /**
         * <p>
         * The list of VPCs that are authorized to be associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        The list of VPCs that are authorized to be associated with the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(VPC... vpCs);
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String nextToken;

        private List<VPC> vpCs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVPCAssociationAuthorizationsResponse model) {
            hostedZoneId(model.hostedZoneId);
            nextToken(model.nextToken);
            vpCs(model.vpCs);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VPC.Builder> getVPCs() {
            return vpCs != null ? vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC... vpCs) {
            vpCs(Arrays.asList(vpCs));
            return this;
        }

        public final void setVPCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        public ListVPCAssociationAuthorizationsResponse build() {
            return new ListVPCAssociationAuthorizationsResponse(this);
        }
    }
}
