/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;

import software.amazon.awssdk.core.util.XmlWriter;

/**
 * ChangeResourceRecordSetsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ChangeResourceRecordSetsRequestMarshaller implements
        Marshaller<Request<ChangeResourceRecordSetsRequest>, ChangeResourceRecordSetsRequest> {

    public Request<ChangeResourceRecordSetsRequest> marshall(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {

        if (changeResourceRecordSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ChangeResourceRecordSetsRequest> request = new DefaultRequest<ChangeResourceRecordSetsRequest>(
                changeResourceRecordSetsRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset/";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Id", changeResourceRecordSetsRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("ChangeResourceRecordSetsRequest");

            ChangeBatch changeBatch = changeResourceRecordSetsRequest.changeBatch();
            if (changeBatch != null) {
                xmlWriter.startElement("ChangeBatch");

                if (changeBatch.comment() != null) {
                    xmlWriter.startElement("Comment").value(changeBatch.comment()).endElement();
                }

                java.util.List<Change> changeBatchChangesList = changeBatch.changes();
                if (changeBatchChangesList != null) {
                    xmlWriter.startElement("Changes");

                    for (Change changeBatchChangesListValue : changeBatchChangesList) {
                        xmlWriter.startElement("Change");

                        if (changeBatchChangesListValue.actionString() != null) {
                            xmlWriter.startElement("Action").value(changeBatchChangesListValue.actionString()).endElement();
                        }

                        ResourceRecordSet resourceRecordSet = changeBatchChangesListValue.resourceRecordSet();
                        if (resourceRecordSet != null) {
                            xmlWriter.startElement("ResourceRecordSet");

                            if (resourceRecordSet.name() != null) {
                                xmlWriter.startElement("Name").value(resourceRecordSet.name()).endElement();
                            }

                            if (resourceRecordSet.typeString() != null) {
                                xmlWriter.startElement("Type").value(resourceRecordSet.typeString()).endElement();
                            }

                            if (resourceRecordSet.setIdentifier() != null) {
                                xmlWriter.startElement("SetIdentifier").value(resourceRecordSet.setIdentifier()).endElement();
                            }

                            if (resourceRecordSet.weight() != null) {
                                xmlWriter.startElement("Weight").value(resourceRecordSet.weight()).endElement();
                            }

                            if (resourceRecordSet.regionString() != null) {
                                xmlWriter.startElement("Region").value(resourceRecordSet.regionString()).endElement();
                            }

                            GeoLocation geoLocation = resourceRecordSet.geoLocation();
                            if (geoLocation != null) {
                                xmlWriter.startElement("GeoLocation");

                                if (geoLocation.continentCode() != null) {
                                    xmlWriter.startElement("ContinentCode").value(geoLocation.continentCode()).endElement();
                                }

                                if (geoLocation.countryCode() != null) {
                                    xmlWriter.startElement("CountryCode").value(geoLocation.countryCode()).endElement();
                                }

                                if (geoLocation.subdivisionCode() != null) {
                                    xmlWriter.startElement("SubdivisionCode").value(geoLocation.subdivisionCode()).endElement();
                                }
                                xmlWriter.endElement();
                            }

                            if (resourceRecordSet.failoverString() != null) {
                                xmlWriter.startElement("Failover").value(resourceRecordSet.failoverString()).endElement();
                            }

                            if (resourceRecordSet.multiValueAnswer() != null) {
                                xmlWriter.startElement("MultiValueAnswer").value(resourceRecordSet.multiValueAnswer())
                                        .endElement();
                            }

                            if (resourceRecordSet.ttl() != null) {
                                xmlWriter.startElement("TTL").value(resourceRecordSet.ttl()).endElement();
                            }

                            java.util.List<ResourceRecord> resourceRecordSetResourceRecordsList = resourceRecordSet
                                    .resourceRecords();
                            if (resourceRecordSetResourceRecordsList != null) {
                                xmlWriter.startElement("ResourceRecords");

                                for (ResourceRecord resourceRecordSetResourceRecordsListValue : resourceRecordSetResourceRecordsList) {
                                    xmlWriter.startElement("ResourceRecord");

                                    if (resourceRecordSetResourceRecordsListValue.value() != null) {
                                        xmlWriter.startElement("Value").value(resourceRecordSetResourceRecordsListValue.value())
                                                .endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }

                            AliasTarget aliasTarget = resourceRecordSet.aliasTarget();
                            if (aliasTarget != null) {
                                xmlWriter.startElement("AliasTarget");

                                if (aliasTarget.hostedZoneId() != null) {
                                    xmlWriter.startElement("HostedZoneId").value(aliasTarget.hostedZoneId()).endElement();
                                }

                                if (aliasTarget.dnsName() != null) {
                                    xmlWriter.startElement("DNSName").value(aliasTarget.dnsName()).endElement();
                                }

                                if (aliasTarget.evaluateTargetHealth() != null) {
                                    xmlWriter.startElement("EvaluateTargetHealth").value(aliasTarget.evaluateTargetHealth())
                                            .endElement();
                                }
                                xmlWriter.endElement();
                            }

                            if (resourceRecordSet.healthCheckId() != null) {
                                xmlWriter.startElement("HealthCheckId").value(resourceRecordSet.healthCheckId()).endElement();
                            }

                            if (resourceRecordSet.trafficPolicyInstanceId() != null) {
                                xmlWriter.startElement("TrafficPolicyInstanceId")
                                        .value(resourceRecordSet.trafficPolicyInstanceId()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}