/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;

import software.amazon.awssdk.core.util.XmlWriter;

/**
 * ChangeTagsForResourceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ChangeTagsForResourceRequestMarshaller implements
        Marshaller<Request<ChangeTagsForResourceRequest>, ChangeTagsForResourceRequest> {

    public Request<ChangeTagsForResourceRequest> marshall(ChangeTagsForResourceRequest changeTagsForResourceRequest) {

        if (changeTagsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ChangeTagsForResourceRequest> request = new DefaultRequest<ChangeTagsForResourceRequest>(
                changeTagsForResourceRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/tags/{ResourceType}/{ResourceId}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "ResourceType", changeTagsForResourceRequest.resourceTypeString());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "ResourceId", changeTagsForResourceRequest.resourceId());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("ChangeTagsForResourceRequest");

            java.util.List<Tag> changeTagsForResourceRequestAddTagsList = changeTagsForResourceRequest.addTags();
            if (changeTagsForResourceRequestAddTagsList != null) {
                xmlWriter.startElement("AddTags");

                for (Tag changeTagsForResourceRequestAddTagsListValue : changeTagsForResourceRequestAddTagsList) {
                    xmlWriter.startElement("Tag");

                    if (changeTagsForResourceRequestAddTagsListValue.key() != null) {
                        xmlWriter.startElement("Key").value(changeTagsForResourceRequestAddTagsListValue.key()).endElement();
                    }

                    if (changeTagsForResourceRequestAddTagsListValue.value() != null) {
                        xmlWriter.startElement("Value").value(changeTagsForResourceRequestAddTagsListValue.value()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.List<String> changeTagsForResourceRequestRemoveTagKeysList = changeTagsForResourceRequest.removeTagKeys();
            if (changeTagsForResourceRequestRemoveTagKeysList != null) {
                xmlWriter.startElement("RemoveTagKeys");

                for (String changeTagsForResourceRequestRemoveTagKeysListValue : changeTagsForResourceRequestRemoveTagKeysList) {
                    xmlWriter.startElement("Key");
                    xmlWriter.value(changeTagsForResourceRequestRemoveTagKeysListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}