/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityResponse;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusRequest;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsResponse;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailResponse;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RenewDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RenewDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailRequest;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailResponse;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeResponse;
import software.amazon.awssdk.services.route53domains.model.TransferDomainRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing null asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Route 53 API actions let you register domain names and perform related operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface Route53DomainsAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link Route53DomainsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static Route53DomainsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53DomainsAsyncClient}.
     */
    static Route53DomainsAsyncClientBuilder builder() {
        return new DefaultRoute53DomainsAsyncClientBuilder();
    }

    /**
     * <p>
     * This operation checks the availability of one domain name. Note that if the availability status of a domain is
     * pending, you must submit another request to determine the availability of the domain name.
     * </p>
     *
     * @param checkDomainAvailabilityRequest
     *        The CheckDomainAvailability request contains the following elements.
     * @return A Java Future containing the result of the CheckDomainAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.CheckDomainAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckDomainAvailabilityResponse> checkDomainAvailability(
            CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation checks the availability of one domain name. Note that if the availability status of a domain is
     * pending, you must submit another request to determine the availability of the domain name.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CheckDomainAvailabilityRequest.Builder} avoiding
     * the need to create one manually via {@link CheckDomainAvailabilityRequest#builder()}
     *
     * @param checkDomainAvailabilityRequest
     *        a {@link Consumer} that will call methods on {@link CheckDomainAvailabilityRequest.Builder}.
     * @return A Java Future containing the result of the CheckDomainAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.CheckDomainAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckDomainAvailabilityResponse> checkDomainAvailability(
            Consumer<CheckDomainAvailabilityRequest.Builder> checkDomainAvailabilityRequest) {
        return checkDomainAvailability(CheckDomainAvailabilityRequest.builder().apply(checkDomainAvailabilityRequest).build());
    }

    /**
     * <p>
     * Checks whether a domain name can be transferred to Amazon Route 53.
     * </p>
     *
     * @param checkDomainTransferabilityRequest
     *        The CheckDomainTransferability request contains the following elements.
     * @return A Java Future containing the result of the CheckDomainTransferability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.CheckDomainTransferability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainTransferability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckDomainTransferabilityResponse> checkDomainTransferability(
            CheckDomainTransferabilityRequest checkDomainTransferabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks whether a domain name can be transferred to Amazon Route 53.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CheckDomainTransferabilityRequest.Builder} avoiding
     * the need to create one manually via {@link CheckDomainTransferabilityRequest#builder()}
     *
     * @param checkDomainTransferabilityRequest
     *        a {@link Consumer} that will call methods on {@link CheckDomainTransferabilityRequest.Builder}.
     * @return A Java Future containing the result of the CheckDomainTransferability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.CheckDomainTransferability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/CheckDomainTransferability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CheckDomainTransferabilityResponse> checkDomainTransferability(
            Consumer<CheckDomainTransferabilityRequest.Builder> checkDomainTransferabilityRequest) {
        return checkDomainTransferability(CheckDomainTransferabilityRequest.builder().apply(checkDomainTransferabilityRequest)
                .build());
    }

    /**
     * <p>
     * This operation deletes the specified tags for a domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     *
     * @param deleteTagsForDomainRequest
     *        The DeleteTagsForDomainRequest includes the following elements.
     * @return A Java Future containing the result of the DeleteTagsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.DeleteTagsForDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DeleteTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTagsForDomainResponse> deleteTagsForDomain(
            DeleteTagsForDomainRequest deleteTagsForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation deletes the specified tags for a domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteTagsForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTagsForDomainRequest#builder()}
     *
     * @param deleteTagsForDomainRequest
     *        a {@link Consumer} that will call methods on {@link DeleteTagsForDomainRequest.Builder}.
     * @return A Java Future containing the result of the DeleteTagsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.DeleteTagsForDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DeleteTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTagsForDomainResponse> deleteTagsForDomain(
            Consumer<DeleteTagsForDomainRequest.Builder> deleteTagsForDomainRequest) {
        return deleteTagsForDomain(DeleteTagsForDomainRequest.builder().apply(deleteTagsForDomainRequest).build());
    }

    /**
     * <p>
     * This operation disables automatic renewal of domain registration for the specified domain.
     * </p>
     *
     * @param disableDomainAutoRenewRequest
     * @return A Java Future containing the result of the DisableDomainAutoRenew operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.DisableDomainAutoRenew
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDomainAutoRenewResponse> disableDomainAutoRenew(
            DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation disables automatic renewal of domain registration for the specified domain.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DisableDomainAutoRenewRequest.Builder} avoiding the
     * need to create one manually via {@link DisableDomainAutoRenewRequest#builder()}
     *
     * @param disableDomainAutoRenewRequest
     *        a {@link Consumer} that will call methods on {@link DisableDomainAutoRenewRequest.Builder}.
     * @return A Java Future containing the result of the DisableDomainAutoRenew operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.DisableDomainAutoRenew
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDomainAutoRenewResponse> disableDomainAutoRenew(
            Consumer<DisableDomainAutoRenewRequest.Builder> disableDomainAutoRenewRequest) {
        return disableDomainAutoRenew(DisableDomainAutoRenewRequest.builder().apply(disableDomainAutoRenewRequest).build());
    }

    /**
     * <p>
     * This operation removes the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to
     * transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to
     * track the progress and completion of the action. If the request is not completed successfully, the domain
     * registrant will be notified by email.
     * </p>
     *
     * @param disableDomainTransferLockRequest
     *        The DisableDomainTransferLock request includes the following element.
     * @return A Java Future containing the result of the DisableDomainTransferLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.DisableDomainTransferLock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDomainTransferLockResponse> disableDomainTransferLock(
            DisableDomainTransferLockRequest disableDomainTransferLockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation removes the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to
     * transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to
     * track the progress and completion of the action. If the request is not completed successfully, the domain
     * registrant will be notified by email.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DisableDomainTransferLockRequest.Builder} avoiding
     * the need to create one manually via {@link DisableDomainTransferLockRequest#builder()}
     *
     * @param disableDomainTransferLockRequest
     *        a {@link Consumer} that will call methods on {@link DisableDomainTransferLockRequest.Builder}.
     * @return A Java Future containing the result of the DisableDomainTransferLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.DisableDomainTransferLock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/DisableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDomainTransferLockResponse> disableDomainTransferLock(
            Consumer<DisableDomainTransferLockRequest.Builder> disableDomainTransferLockRequest) {
        return disableDomainTransferLock(DisableDomainTransferLockRequest.builder().apply(disableDomainTransferLockRequest)
                .build());
    }

    /**
     * <p>
     * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain
     * registration expires. The cost of renewing your domain registration is billed to your AWS account.
     * </p>
     * <p>
     * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies,
     * see <a href="http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times">
     * "Renewal, restoration, and deletion times"</a> on the website for our registrar partner, Gandi. Route 53 requires
     * that you renew before the end of the renewal period that is listed on the Gandi website so we can complete
     * processing before the deadline.
     * </p>
     *
     * @param enableDomainAutoRenewRequest
     * @return A Java Future containing the result of the EnableDomainAutoRenew operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.EnableDomainAutoRenew
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDomainAutoRenewResponse> enableDomainAutoRenew(
            EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain
     * registration expires. The cost of renewing your domain registration is billed to your AWS account.
     * </p>
     * <p>
     * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies,
     * see <a href="http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times">
     * "Renewal, restoration, and deletion times"</a> on the website for our registrar partner, Gandi. Route 53 requires
     * that you renew before the end of the renewal period that is listed on the Gandi website so we can complete
     * processing before the deadline.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link EnableDomainAutoRenewRequest.Builder} avoiding the
     * need to create one manually via {@link EnableDomainAutoRenewRequest#builder()}
     *
     * @param enableDomainAutoRenewRequest
     *        a {@link Consumer} that will call methods on {@link EnableDomainAutoRenewRequest.Builder}.
     * @return A Java Future containing the result of the EnableDomainAutoRenew operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.EnableDomainAutoRenew
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainAutoRenew"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDomainAutoRenewResponse> enableDomainAutoRenew(
            Consumer<EnableDomainAutoRenewRequest.Builder> enableDomainAutoRenewRequest) {
        return enableDomainAutoRenew(EnableDomainAutoRenewRequest.builder().apply(enableDomainAutoRenewRequest).build());
    }

    /**
     * <p>
     * This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the
     * progress and completion of the action. If the request is not completed successfully, the domain registrant will
     * be notified by email.
     * </p>
     *
     * @param enableDomainTransferLockRequest
     *        A request to set the transfer lock for the specified domain.
     * @return A Java Future containing the result of the EnableDomainTransferLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.EnableDomainTransferLock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDomainTransferLockResponse> enableDomainTransferLock(
            EnableDomainTransferLockRequest enableDomainTransferLockRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code>
     * status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the
     * progress and completion of the action. If the request is not completed successfully, the domain registrant will
     * be notified by email.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link EnableDomainTransferLockRequest.Builder} avoiding
     * the need to create one manually via {@link EnableDomainTransferLockRequest#builder()}
     *
     * @param enableDomainTransferLockRequest
     *        a {@link Consumer} that will call methods on {@link EnableDomainTransferLockRequest.Builder}.
     * @return A Java Future containing the result of the EnableDomainTransferLock operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.EnableDomainTransferLock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainTransferLock"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDomainTransferLockResponse> enableDomainTransferLock(
            Consumer<EnableDomainTransferLockRequest.Builder> enableDomainTransferLockRequest) {
        return enableDomainTransferLock(EnableDomainTransferLockRequest.builder().apply(enableDomainTransferLockRequest).build());
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation returns information about whether the registrant contact has responded.
     * </p>
     * <p>
     * If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.
     * </p>
     *
     * @param getContactReachabilityStatusRequest
     * @return A Java Future containing the result of the GetContactReachabilityStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetContactReachabilityStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetContactReachabilityStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContactReachabilityStatusResponse> getContactReachabilityStatus(
            GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation returns information about whether the registrant contact has responded.
     * </p>
     * <p>
     * If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetContactReachabilityStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetContactReachabilityStatusRequest#builder()}
     *
     * @param getContactReachabilityStatusRequest
     *        a {@link Consumer} that will call methods on {@link GetContactReachabilityStatusRequest.Builder}.
     * @return A Java Future containing the result of the GetContactReachabilityStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetContactReachabilityStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetContactReachabilityStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContactReachabilityStatusResponse> getContactReachabilityStatus(
            Consumer<GetContactReachabilityStatusRequest.Builder> getContactReachabilityStatusRequest) {
        return getContactReachabilityStatus(GetContactReachabilityStatusRequest.builder()
                .apply(getContactReachabilityStatusRequest).build());
    }

    /**
     * <p>
     * This operation returns detailed information about a specified domain that is associated with the current AWS
     * account. Contact information for the domain is also returned as part of the output.
     * </p>
     *
     * @param getDomainDetailRequest
     *        The GetDomainDetail request includes the following element.
     * @return A Java Future containing the result of the GetDomainDetail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetDomainDetail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainDetail" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDomainDetailResponse> getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns detailed information about a specified domain that is associated with the current AWS
     * account. Contact information for the domain is also returned as part of the output.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetDomainDetailRequest.Builder} avoiding the need
     * to create one manually via {@link GetDomainDetailRequest#builder()}
     *
     * @param getDomainDetailRequest
     *        a {@link Consumer} that will call methods on {@link GetDomainDetailRequest.Builder}.
     * @return A Java Future containing the result of the GetDomainDetail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetDomainDetail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainDetail" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDomainDetailResponse> getDomainDetail(
            Consumer<GetDomainDetailRequest.Builder> getDomainDetailRequest) {
        return getDomainDetail(GetDomainDetailRequest.builder().apply(getDomainDetailRequest).build());
    }

    /**
     * <p>
     * The GetDomainSuggestions operation returns a list of suggested domain names given a string, which can either be a
     * domain name or simply a word or phrase (without spaces).
     * </p>
     *
     * @param getDomainSuggestionsRequest
     * @return A Java Future containing the result of the GetDomainSuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetDomainSuggestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainSuggestionsResponse> getDomainSuggestions(
            GetDomainSuggestionsRequest getDomainSuggestionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The GetDomainSuggestions operation returns a list of suggested domain names given a string, which can either be a
     * domain name or simply a word or phrase (without spaces).
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetDomainSuggestionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDomainSuggestionsRequest#builder()}
     *
     * @param getDomainSuggestionsRequest
     *        a {@link Consumer} that will call methods on {@link GetDomainSuggestionsRequest.Builder}.
     * @return A Java Future containing the result of the GetDomainSuggestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetDomainSuggestions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetDomainSuggestions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainSuggestionsResponse> getDomainSuggestions(
            Consumer<GetDomainSuggestionsRequest.Builder> getDomainSuggestionsRequest) {
        return getDomainSuggestions(GetDomainSuggestionsRequest.builder().apply(getDomainSuggestionsRequest).build());
    }

    /**
     * <p>
     * This operation returns the current status of an operation that is not completed.
     * </p>
     *
     * @param getOperationDetailRequest
     *        The <a>GetOperationDetail</a> request includes the following element.
     * @return A Java Future containing the result of the GetOperationDetail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetOperationDetail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetOperationDetail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOperationDetailResponse> getOperationDetail(GetOperationDetailRequest getOperationDetailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the current status of an operation that is not completed.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetOperationDetailRequest.Builder} avoiding the
     * need to create one manually via {@link GetOperationDetailRequest#builder()}
     *
     * @param getOperationDetailRequest
     *        a {@link Consumer} that will call methods on {@link GetOperationDetailRequest.Builder}.
     * @return A Java Future containing the result of the GetOperationDetail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.GetOperationDetail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/GetOperationDetail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOperationDetailResponse> getOperationDetail(
            Consumer<GetOperationDetailRequest.Builder> getOperationDetailRequest) {
        return getOperationDetail(GetOperationDetailRequest.builder().apply(getOperationDetailRequest).build());
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current AWS account.
     * </p>
     *
     * @param listDomainsRequest
     *        The ListDomains request includes the following elements.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains() {
        return listDomains(ListDomainsRequest.builder().build());
    }

    /**
     * <p>
     * This operation returns all the domain names registered with Amazon Route 53 for the current AWS account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     *
     * @param listDomainsRequest
     *        a {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder}.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().apply(listDomainsRequest).build());
    }

    /**
     * <p>
     * This operation returns the operation IDs of operations that are not yet complete.
     * </p>
     *
     * @param listOperationsRequest
     *        The ListOperations request includes the following elements.
     * @return A Java Future containing the result of the ListOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOperationsResponse> listOperations(ListOperationsRequest listOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the operation IDs of operations that are not yet complete.
     * </p>
     *
     * @return A Java Future containing the result of the ListOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOperationsResponse> listOperations() {
        return listOperations(ListOperationsRequest.builder().build());
    }

    /**
     * <p>
     * This operation returns the operation IDs of operations that are not yet complete.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOperationsRequest#builder()}
     *
     * @param listOperationsRequest
     *        a {@link Consumer} that will call methods on {@link ListOperationsRequest.Builder}.
     * @return A Java Future containing the result of the ListOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOperationsResponse> listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest) {
        return listOperations(ListOperationsRequest.builder().apply(listOperationsRequest).build());
    }

    /**
     * <p>
     * This operation returns all of the tags that are associated with the specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     *
     * @param listTagsForDomainRequest
     *        The ListTagsForDomainRequest includes the following elements.
     * @return A Java Future containing the result of the ListTagsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListTagsForDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForDomainResponse> listTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns all of the tags that are associated with the specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListTagsForDomainRequest.Builder} avoiding the need
     * to create one manually via {@link ListTagsForDomainRequest#builder()}
     *
     * @param listTagsForDomainRequest
     *        a {@link Consumer} that will call methods on {@link ListTagsForDomainRequest.Builder}.
     * @return A Java Future containing the result of the ListTagsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ListTagsForDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ListTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForDomainResponse> listTagsForDomain(
            Consumer<ListTagsForDomainRequest.Builder> listTagsForDomainRequest) {
        return listTagsForDomain(ListTagsForDomainRequest.builder().apply(listTagsForDomainRequest).build());
    }

    /**
     * <p>
     * This operation registers a domain. Domains are registered by the AWS registrar partner, Gandi. For some top-level
     * domains (TLDs), this operation requires extra parameters.
     * </p>
     * <p>
     * When you register a domain, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a Amazon Route 53 hosted zone that has the same name as the domain. Amazon Route 53 assigns four name
     * servers to your hosted zone and automatically updates your domain registration with the names of these name
     * servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of
     * the renewal date so you can choose whether to renew the registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally enables privacy protection, so WHOIS queries return contact information for our registrar partner,
     * Gandi, instead of the information you entered for registrant, admin, and tech contacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * If registration is successful, returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant is notified by email.
     * </p>
     * </li>
     * <li>
     * <p>
     * Charges your AWS account an amount based on the top-level domain. For more information, see <a
     * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param registerDomainRequest
     *        The RegisterDomain request includes the following elements.
     * @return A Java Future containing the result of the RegisterDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>DomainLimitExceededException The number of domains has exceeded the allowed threshold for the
     *         account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.RegisterDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterDomainResponse> registerDomain(RegisterDomainRequest registerDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation registers a domain. Domains are registered by the AWS registrar partner, Gandi. For some top-level
     * domains (TLDs), this operation requires extra parameters.
     * </p>
     * <p>
     * When you register a domain, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a Amazon Route 53 hosted zone that has the same name as the domain. Amazon Route 53 assigns four name
     * servers to your hosted zone and automatically updates your domain registration with the names of these name
     * servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of
     * the renewal date so you can choose whether to renew the registration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally enables privacy protection, so WHOIS queries return contact information for our registrar partner,
     * Gandi, instead of the information you entered for registrant, admin, and tech contacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * If registration is successful, returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant is notified by email.
     * </p>
     * </li>
     * <li>
     * <p>
     * Charges your AWS account an amount based on the top-level domain. For more information, see <a
     * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterDomainRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterDomainRequest#builder()}
     *
     * @param registerDomainRequest
     *        a {@link Consumer} that will call methods on {@link RegisterDomainRequest.Builder}.
     * @return A Java Future containing the result of the RegisterDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>DomainLimitExceededException The number of domains has exceeded the allowed threshold for the
     *         account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.RegisterDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterDomainResponse> registerDomain(Consumer<RegisterDomainRequest.Builder> registerDomainRequest) {
        return registerDomain(RegisterDomainRequest.builder().apply(registerDomainRequest).build());
    }

    /**
     * <p>
     * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to
     * your AWS account.
     * </p>
     * <p>
     * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete
     * domains before the expiration date if you haven't renewed far enough in advance. For more information about
     * renewing domain registration, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a
     * Domain</a> in the Amazon Route 53 Developer Guide.
     * </p>
     *
     * @param renewDomainRequest
     *        A <code>RenewDomain</code> request includes the number of years that you want to renew for and the current
     *        expiration year.
     * @return A Java Future containing the result of the RenewDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.RenewDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RenewDomainResponse> renewDomain(RenewDomainRequest renewDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to
     * your AWS account.
     * </p>
     * <p>
     * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete
     * domains before the expiration date if you haven't renewed far enough in advance. For more information about
     * renewing domain registration, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a
     * Domain</a> in the Amazon Route 53 Developer Guide.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RenewDomainRequest.Builder} avoiding the need to
     * create one manually via {@link RenewDomainRequest#builder()}
     *
     * @param renewDomainRequest
     *        a {@link Consumer} that will call methods on {@link RenewDomainRequest.Builder}.
     * @return A Java Future containing the result of the RenewDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.RenewDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RenewDomainResponse> renewDomain(Consumer<RenewDomainRequest.Builder> renewDomainRequest) {
        return renewDomain(RenewDomainRequest.builder().apply(renewDomainRequest).build());
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation resends the confirmation email to the current email address for the
     * registrant contact.
     * </p>
     *
     * @param resendContactReachabilityEmailRequest
     * @return A Java Future containing the result of the ResendContactReachabilityEmail operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ResendContactReachabilityEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendContactReachabilityEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendContactReachabilityEmailResponse> resendContactReachabilityEmail(
            ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation resends the confirmation email to the current email address for the
     * registrant contact.
     * </p>
     *
     * @return A Java Future containing the result of the ResendContactReachabilityEmail operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ResendContactReachabilityEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendContactReachabilityEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendContactReachabilityEmailResponse> resendContactReachabilityEmail() {
        return resendContactReachabilityEmail(ResendContactReachabilityEmailRequest.builder().build());
    }

    /**
     * <p>
     * For operations that require confirmation that the email address for the registrant contact is valid, such as
     * registering a new domain, this operation resends the confirmation email to the current email address for the
     * registrant contact.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ResendContactReachabilityEmailRequest.Builder}
     * avoiding the need to create one manually via {@link ResendContactReachabilityEmailRequest#builder()}
     *
     * @param resendContactReachabilityEmailRequest
     *        a {@link Consumer} that will call methods on {@link ResendContactReachabilityEmailRequest.Builder}.
     * @return A Java Future containing the result of the ResendContactReachabilityEmail operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ResendContactReachabilityEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ResendContactReachabilityEmail"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResendContactReachabilityEmailResponse> resendContactReachabilityEmail(
            Consumer<ResendContactReachabilityEmailRequest.Builder> resendContactReachabilityEmailRequest) {
        return resendContactReachabilityEmail(ResendContactReachabilityEmailRequest.builder()
                .apply(resendContactReachabilityEmailRequest).build());
    }

    /**
     * <p>
     * This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this
     * value to the new registrar.
     * </p>
     *
     * @param retrieveDomainAuthCodeRequest
     *        A request for the authorization code for the specified domain. To transfer a domain to another registrar,
     *        you provide this value to the new registrar.
     * @return A Java Future containing the result of the RetrieveDomainAuthCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.RetrieveDomainAuthCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RetrieveDomainAuthCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveDomainAuthCodeResponse> retrieveDomainAuthCode(
            RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this
     * value to the new registrar.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link RetrieveDomainAuthCodeRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveDomainAuthCodeRequest#builder()}
     *
     * @param retrieveDomainAuthCodeRequest
     *        a {@link Consumer} that will call methods on {@link RetrieveDomainAuthCodeRequest.Builder}.
     * @return A Java Future containing the result of the RetrieveDomainAuthCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.RetrieveDomainAuthCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RetrieveDomainAuthCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveDomainAuthCodeResponse> retrieveDomainAuthCode(
            Consumer<RetrieveDomainAuthCodeRequest.Builder> retrieveDomainAuthCodeRequest) {
        return retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest.builder().apply(retrieveDomainAuthCodeRequest).build());
    }

    /**
     * <p>
     * This operation transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the
     * domain is registered with the AWS registrar partner, Gandi.
     * </p>
     * <p>
     * For transfer requirements, a detailed procedure, and information about viewing the status of a domain transfer,
     * see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring
     * Registration for a Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you
     * consider transferring your DNS service to Amazon Route 53 or to another DNS service provider before you transfer
     * your registration. Some registrars provide free DNS service when you purchase a domain registration. When you
     * transfer the registration, the previous registrar will not renew your domain registration and could end your DNS
     * service at any time.
     * </p>
     * <important>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS
     * service to another provider, your website, email, and the web applications associated with the domain might
     * become unavailable.
     * </p>
     * </important>
     * <p>
     * If the transfer is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified
     * by email.
     * </p>
     *
     * @param transferDomainRequest
     *        The TransferDomain request includes the following elements.
     * @return A Java Future containing the result of the TransferDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>DomainLimitExceededException The number of domains has exceeded the allowed threshold for the
     *         account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.TransferDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TransferDomainResponse> transferDomain(TransferDomainRequest transferDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the
     * domain is registered with the AWS registrar partner, Gandi.
     * </p>
     * <p>
     * For transfer requirements, a detailed procedure, and information about viewing the status of a domain transfer,
     * see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring
     * Registration for a Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you
     * consider transferring your DNS service to Amazon Route 53 or to another DNS service provider before you transfer
     * your registration. Some registrars provide free DNS service when you purchase a domain registration. When you
     * transfer the registration, the previous registrar will not renew your domain registration and could end your DNS
     * service at any time.
     * </p>
     * <important>
     * <p>
     * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS
     * service to another provider, your website, email, and the web applications associated with the domain might
     * become unavailable.
     * </p>
     * </important>
     * <p>
     * If the transfer is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified
     * by email.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link TransferDomainRequest.Builder} avoiding the need to
     * create one manually via {@link TransferDomainRequest#builder()}
     *
     * @param transferDomainRequest
     *        a {@link Consumer} that will call methods on {@link TransferDomainRequest.Builder}.
     * @return A Java Future containing the result of the TransferDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>DomainLimitExceededException The number of domains has exceeded the allowed threshold for the
     *         account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.TransferDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/TransferDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TransferDomainResponse> transferDomain(Consumer<TransferDomainRequest.Builder> transferDomainRequest) {
        return transferDomain(TransferDomainRequest.builder().apply(transferDomainRequest).build());
    }

    /**
     * <p>
     * This operation updates the contact information for a particular domain. Information for at least one contact
     * (registrant, administrator, or technical) must be supplied for update.
     * </p>
     * <p>
     * If the update is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the action. If the request is not completed successfully, the domain registrant will be notified by
     * email.
     * </p>
     *
     * @param updateDomainContactRequest
     *        The UpdateDomainContact request includes the following elements.
     * @return A Java Future containing the result of the UpdateDomainContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateDomainContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDomainContactResponse> updateDomainContact(
            UpdateDomainContactRequest updateDomainContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates the contact information for a particular domain. Information for at least one contact
     * (registrant, administrator, or technical) must be supplied for update.
     * </p>
     * <p>
     * If the update is successful, this method returns an operation ID that you can use to track the progress and
     * completion of the action. If the request is not completed successfully, the domain registrant will be notified by
     * email.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateDomainContactRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainContactRequest#builder()}
     *
     * @param updateDomainContactRequest
     *        a {@link Consumer} that will call methods on {@link UpdateDomainContactRequest.Builder}.
     * @return A Java Future containing the result of the UpdateDomainContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateDomainContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDomainContactResponse> updateDomainContact(
            Consumer<UpdateDomainContactRequest.Builder> updateDomainContactRequest) {
        return updateDomainContact(UpdateDomainContactRequest.builder().apply(updateDomainContactRequest).build());
    }

    /**
     * <p>
     * This operation updates the specified domain contact's privacy setting. When the privacy option is enabled,
     * personal information such as postal or email address is hidden from the results of a public WHOIS query. The
     * privacy services are provided by the AWS registrar, Gandi. For more information, see the <a
     * href="http://www.gandi.net/domain/whois/?currency=USD&amp;amp;lang=en">Gandi privacy features</a>.
     * </p>
     * <p>
     * This operation only affects the privacy of the specified contact type (registrant, administrator, or tech).
     * Successful acceptance returns an operation ID that you can use with <a>GetOperationDetail</a> to track the
     * progress and completion of the action. If the request is not completed successfully, the domain registrant will
     * be notified by email.
     * </p>
     *
     * @param updateDomainContactPrivacyRequest
     *        The UpdateDomainContactPrivacy request includes the following elements.
     * @return A Java Future containing the result of the UpdateDomainContactPrivacy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateDomainContactPrivacy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContactPrivacy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDomainContactPrivacyResponse> updateDomainContactPrivacy(
            UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation updates the specified domain contact's privacy setting. When the privacy option is enabled,
     * personal information such as postal or email address is hidden from the results of a public WHOIS query. The
     * privacy services are provided by the AWS registrar, Gandi. For more information, see the <a
     * href="http://www.gandi.net/domain/whois/?currency=USD&amp;amp;lang=en">Gandi privacy features</a>.
     * </p>
     * <p>
     * This operation only affects the privacy of the specified contact type (registrant, administrator, or tech).
     * Successful acceptance returns an operation ID that you can use with <a>GetOperationDetail</a> to track the
     * progress and completion of the action. If the request is not completed successfully, the domain registrant will
     * be notified by email.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateDomainContactPrivacyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDomainContactPrivacyRequest#builder()}
     *
     * @param updateDomainContactPrivacyRequest
     *        a {@link Consumer} that will call methods on {@link UpdateDomainContactPrivacyRequest.Builder}.
     * @return A Java Future containing the result of the UpdateDomainContactPrivacy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateDomainContactPrivacy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainContactPrivacy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDomainContactPrivacyResponse> updateDomainContactPrivacy(
            Consumer<UpdateDomainContactPrivacyRequest.Builder> updateDomainContactPrivacyRequest) {
        return updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest.builder().apply(updateDomainContactPrivacyRequest)
                .build());
    }

    /**
     * <p>
     * This operation replaces the current set of name servers for the domain with the specified set of name servers. If
     * you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted
     * zone for the domain.
     * </p>
     * <p>
     * If successful, this operation returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant will be notified by email.
     * </p>
     *
     * @param updateDomainNameserversRequest
     *        Replaces the current set of name servers for the domain with the specified set of name servers. If you use
     *        Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted
     *        zone for the domain.</p>
     *        <p>
     *        If successful, this operation returns an operation ID that you can use to track the progress and
     *        completion of the action. If the request is not completed successfully, the domain registrant will be
     *        notified by email.
     * @return A Java Future containing the result of the UpdateDomainNameservers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li> <li>DuplicateRequestException The request is already
     *         in progress for the domain.</li> <li>TLDRulesViolationException The top-level domain does not support
     *         this operation.</li> <li>OperationLimitExceededException The number of operations or jobs running
     *         exceeded the allowed threshold for the account.</li> <li>UnsupportedTLDException Amazon Route 53 does not
     *         support this top-level domain (TLD).</li> <li>SdkBaseException Base class for all exceptions that can be
     *         thrown by the SDK (both service and client). Can be used for catch all scenarios.</li> <li>
     *         SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li> <li>Route53DomainsException Base class for all service exceptions. Unknown
     *         exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateDomainNameservers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainNameservers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDomainNameserversResponse> updateDomainNameservers(
            UpdateDomainNameserversRequest updateDomainNameserversRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation replaces the current set of name servers for the domain with the specified set of name servers. If
     * you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted
     * zone for the domain.
     * </p>
     * <p>
     * If successful, this operation returns an operation ID that you can use to track the progress and completion of
     * the action. If the request is not completed successfully, the domain registrant will be notified by email.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameserversRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDomainNameserversRequest#builder()}
     *
     * @param updateDomainNameserversRequest
     *        a {@link Consumer} that will call methods on {@link UpdateDomainNameserversRequest.Builder}.
     * @return A Java Future containing the result of the UpdateDomainNameservers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>DuplicateRequestException The request is already in progress for the domain.</li>
     *         <li>TLDRulesViolationException The top-level domain does not support this operation.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateDomainNameservers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateDomainNameservers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDomainNameserversResponse> updateDomainNameservers(
            Consumer<UpdateDomainNameserversRequest.Builder> updateDomainNameserversRequest) {
        return updateDomainNameservers(UpdateDomainNameserversRequest.builder().apply(updateDomainNameserversRequest).build());
    }

    /**
     * <p>
     * This operation adds or updates tags for a specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     *
     * @param updateTagsForDomainRequest
     *        The UpdateTagsForDomainRequest includes the following elements.
     * @return A Java Future containing the result of the UpdateTagsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateTagsForDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTagsForDomainResponse> updateTagsForDomain(
            UpdateTagsForDomainRequest updateTagsForDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation adds or updates tags for a specified domain.
     * </p>
     * <p>
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued
     * operations.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateTagsForDomainRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTagsForDomainRequest#builder()}
     *
     * @param updateTagsForDomainRequest
     *        a {@link Consumer} that will call methods on {@link UpdateTagsForDomainRequest.Builder}.
     * @return A Java Future containing the result of the UpdateTagsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>OperationLimitExceededException The number of operations or jobs running exceeded the allowed
     *         threshold for the account.</li>
     *         <li>UnsupportedTLDException Amazon Route 53 does not support this top-level domain (TLD).</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.UpdateTagsForDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/UpdateTagsForDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTagsForDomainResponse> updateTagsForDomain(
            Consumer<UpdateTagsForDomainRequest.Builder> updateTagsForDomainRequest) {
        return updateTagsForDomain(UpdateTagsForDomainRequest.builder().apply(updateTagsForDomainRequest).build());
    }

    /**
     * <p>
     * Returns all the domain-related billing records for the current AWS account for a specified period
     * </p>
     *
     * @param viewBillingRequest
     *        The ViewBilling request includes the following elements.
     * @return A Java Future containing the result of the ViewBilling operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ViewBilling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ViewBilling" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ViewBillingResponse> viewBilling(ViewBillingRequest viewBillingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all the domain-related billing records for the current AWS account for a specified period
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ViewBillingRequest.Builder} avoiding the need to
     * create one manually via {@link ViewBillingRequest#builder()}
     *
     * @param viewBillingRequest
     *        a {@link Consumer} that will call methods on {@link ViewBillingRequest.Builder}.
     * @return A Java Future containing the result of the ViewBilling operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The requested item is not acceptable. For example, for an OperationId it might
     *         refer to the ID of an operation that is already completed. For a domain name, it might not be a valid
     *         domain name or belong to the requester account.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53DomainsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Route53DomainsAsyncClient.ViewBilling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/ViewBilling" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ViewBillingResponse> viewBilling(Consumer<ViewBillingRequest.Builder> viewBillingRequest) {
        return viewBilling(ViewBillingRequest.builder().apply(viewBillingRequest).build());
    }
}
