/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainAvailability response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CheckDomainAvailabilityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CheckDomainAvailabilityResponse.Builder, CheckDomainAvailabilityResponse> {
    private final String availability;

    private CheckDomainAvailabilityResponse(BuilderImpl builder) {
        this.availability = builder.availability;
    }

    /**
     * <p>
     * Whether the domain name is available for registering.
     * </p>
     * <note>
     * <p>
     * You can register only domains designated as <code>AVAILABLE</code>.
     * </p>
     * </note>
     * <p>
     * Valid values:
     * </p>
     * <dl>
     * <dt>AVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is available.
     * </p>
     * </dd>
     * <dt>AVAILABLE_RESERVED</dt>
     * <dd>
     * <p>
     * The domain name is reserved under specific conditions.
     * </p>
     * </dd>
     * <dt>AVAILABLE_PREORDER</dt>
     * <dd>
     * <p>
     * The domain name is available and can be preordered.
     * </p>
     * </dd>
     * <dt>DONT_KNOW</dt>
     * <dd>
     * <p>
     * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon Route
     * 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try
     * again later.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
     * usually takes just a few extra seconds. You can resubmit the request immediately.
     * </p>
     * </dd>
     * <dt>RESERVED</dt>
     * <dd>
     * <p>
     * The domain name has been reserved for another person or organization.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_PREMIUM</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_RESTRICTED</dt>
     * <dd>
     * <p>
     * The domain name is forbidden.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availability} will
     * return {@link DomainAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityString}.
     * </p>
     * 
     * @return Whether the domain name is available for registering.</p> <note>
     *         <p>
     *         You can register only domains designated as <code>AVAILABLE</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values:
     *         </p>
     *         <dl>
     *         <dt>AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is available.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name is reserved under specific conditions.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_PREORDER</dt>
     *         <dd>
     *         <p>
     *         The domain name is available and can be preordered.
     *         </p>
     *         </dd>
     *         <dt>DONT_KNOW</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
     *         Route 53 can return this response for a variety of reasons, for example, the registry is performing
     *         maintenance. Try again later.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
     *         it usually takes just a few extra seconds. You can resubmit the request immediately.
     *         </p>
     *         </dd>
     *         <dt>RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name has been reserved for another person or organization.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_PREMIUM</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_RESTRICTED</dt>
     *         <dd>
     *         <p>
     *         The domain name is forbidden.
     *         </p>
     *         </dd>
     * @see DomainAvailability
     */
    public DomainAvailability availability() {
        return DomainAvailability.fromValue(availability);
    }

    /**
     * <p>
     * Whether the domain name is available for registering.
     * </p>
     * <note>
     * <p>
     * You can register only domains designated as <code>AVAILABLE</code>.
     * </p>
     * </note>
     * <p>
     * Valid values:
     * </p>
     * <dl>
     * <dt>AVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is available.
     * </p>
     * </dd>
     * <dt>AVAILABLE_RESERVED</dt>
     * <dd>
     * <p>
     * The domain name is reserved under specific conditions.
     * </p>
     * </dd>
     * <dt>AVAILABLE_PREORDER</dt>
     * <dd>
     * <p>
     * The domain name is available and can be preordered.
     * </p>
     * </dd>
     * <dt>DONT_KNOW</dt>
     * <dd>
     * <p>
     * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon Route
     * 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try
     * again later.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
     * usually takes just a few extra seconds. You can resubmit the request immediately.
     * </p>
     * </dd>
     * <dt>RESERVED</dt>
     * <dd>
     * <p>
     * The domain name has been reserved for another person or organization.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_PREMIUM</dt>
     * <dd>
     * <p>
     * The domain name is not available.
     * </p>
     * </dd>
     * <dt>UNAVAILABLE_RESTRICTED</dt>
     * <dd>
     * <p>
     * The domain name is forbidden.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availability} will
     * return {@link DomainAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityString}.
     * </p>
     * 
     * @return Whether the domain name is available for registering.</p> <note>
     *         <p>
     *         You can register only domains designated as <code>AVAILABLE</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values:
     *         </p>
     *         <dl>
     *         <dt>AVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is available.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name is reserved under specific conditions.
     *         </p>
     *         </dd>
     *         <dt>AVAILABLE_PREORDER</dt>
     *         <dd>
     *         <p>
     *         The domain name is available and can be preordered.
     *         </p>
     *         </dd>
     *         <dt>DONT_KNOW</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
     *         Route 53 can return this response for a variety of reasons, for example, the registry is performing
     *         maintenance. Try again later.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
     *         it usually takes just a few extra seconds. You can resubmit the request immediately.
     *         </p>
     *         </dd>
     *         <dt>RESERVED</dt>
     *         <dd>
     *         <p>
     *         The domain name has been reserved for another person or organization.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_PREMIUM</dt>
     *         <dd>
     *         <p>
     *         The domain name is not available.
     *         </p>
     *         </dd>
     *         <dt>UNAVAILABLE_RESTRICTED</dt>
     *         <dd>
     *         <p>
     *         The domain name is forbidden.
     *         </p>
     *         </dd>
     * @see DomainAvailability
     */
    public String availabilityString() {
        return availability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainAvailabilityResponse)) {
            return false;
        }
        CheckDomainAvailabilityResponse other = (CheckDomainAvailabilityResponse) obj;
        return Objects.equals(availabilityString(), other.availabilityString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityString() != null) {
            sb.append("Availability: ").append(availabilityString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Availability":
            return Optional.of(clazz.cast(availabilityString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CheckDomainAvailabilityResponse> {
        /**
         * <p>
         * Whether the domain name is available for registering.
         * </p>
         * <note>
         * <p>
         * You can register only domains designated as <code>AVAILABLE</code>.
         * </p>
         * </note>
         * <p>
         * Valid values:
         * </p>
         * <dl>
         * <dt>AVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is available.
         * </p>
         * </dd>
         * <dt>AVAILABLE_RESERVED</dt>
         * <dd>
         * <p>
         * The domain name is reserved under specific conditions.
         * </p>
         * </dd>
         * <dt>AVAILABLE_PREORDER</dt>
         * <dd>
         * <p>
         * The domain name is available and can be preordered.
         * </p>
         * </dd>
         * <dt>DONT_KNOW</dt>
         * <dd>
         * <p>
         * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
         * Route 53 can return this response for a variety of reasons, for example, the registry is performing
         * maintenance. Try again later.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
         * usually takes just a few extra seconds. You can resubmit the request immediately.
         * </p>
         * </dd>
         * <dt>RESERVED</dt>
         * <dd>
         * <p>
         * The domain name has been reserved for another person or organization.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_PREMIUM</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_RESTRICTED</dt>
         * <dd>
         * <p>
         * The domain name is forbidden.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param availability
         *        Whether the domain name is available for registering.</p> <note>
         *        <p>
         *        You can register only domains designated as <code>AVAILABLE</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values:
         *        </p>
         *        <dl>
         *        <dt>AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is available.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name is reserved under specific conditions.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_PREORDER</dt>
         *        <dd>
         *        <p>
         *        The domain name is available and can be preordered.
         *        </p>
         *        </dd>
         *        <dt>DONT_KNOW</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't reply with a definitive answer about whether the domain name is available.
         *        Amazon Route 53 can return this response for a variety of reasons, for example, the registry is
         *        performing maintenance. Try again later.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't return a response in the expected amount of time. When the response is
         *        delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.
         *        </p>
         *        </dd>
         *        <dt>RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name has been reserved for another person or organization.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_PREMIUM</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_RESTRICTED</dt>
         *        <dd>
         *        <p>
         *        The domain name is forbidden.
         *        </p>
         *        </dd>
         * @see DomainAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainAvailability
         */
        Builder availability(String availability);

        /**
         * <p>
         * Whether the domain name is available for registering.
         * </p>
         * <note>
         * <p>
         * You can register only domains designated as <code>AVAILABLE</code>.
         * </p>
         * </note>
         * <p>
         * Valid values:
         * </p>
         * <dl>
         * <dt>AVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is available.
         * </p>
         * </dd>
         * <dt>AVAILABLE_RESERVED</dt>
         * <dd>
         * <p>
         * The domain name is reserved under specific conditions.
         * </p>
         * </dd>
         * <dt>AVAILABLE_PREORDER</dt>
         * <dd>
         * <p>
         * The domain name is available and can be preordered.
         * </p>
         * </dd>
         * <dt>DONT_KNOW</dt>
         * <dd>
         * <p>
         * The TLD registry didn't reply with a definitive answer about whether the domain name is available. Amazon
         * Route 53 can return this response for a variety of reasons, for example, the registry is performing
         * maintenance. Try again later.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it
         * usually takes just a few extra seconds. You can resubmit the request immediately.
         * </p>
         * </dd>
         * <dt>RESERVED</dt>
         * <dd>
         * <p>
         * The domain name has been reserved for another person or organization.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_PREMIUM</dt>
         * <dd>
         * <p>
         * The domain name is not available.
         * </p>
         * </dd>
         * <dt>UNAVAILABLE_RESTRICTED</dt>
         * <dd>
         * <p>
         * The domain name is forbidden.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param availability
         *        Whether the domain name is available for registering.</p> <note>
         *        <p>
         *        You can register only domains designated as <code>AVAILABLE</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values:
         *        </p>
         *        <dl>
         *        <dt>AVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is available.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name is reserved under specific conditions.
         *        </p>
         *        </dd>
         *        <dt>AVAILABLE_PREORDER</dt>
         *        <dd>
         *        <p>
         *        The domain name is available and can be preordered.
         *        </p>
         *        </dd>
         *        <dt>DONT_KNOW</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't reply with a definitive answer about whether the domain name is available.
         *        Amazon Route 53 can return this response for a variety of reasons, for example, the registry is
         *        performing maintenance. Try again later.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        The TLD registry didn't return a response in the expected amount of time. When the response is
         *        delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.
         *        </p>
         *        </dd>
         *        <dt>RESERVED</dt>
         *        <dd>
         *        <p>
         *        The domain name has been reserved for another person or organization.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_PREMIUM</dt>
         *        <dd>
         *        <p>
         *        The domain name is not available.
         *        </p>
         *        </dd>
         *        <dt>UNAVAILABLE_RESTRICTED</dt>
         *        <dd>
         *        <p>
         *        The domain name is forbidden.
         *        </p>
         *        </dd>
         * @see DomainAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainAvailability
         */
        Builder availability(DomainAvailability availability);
    }

    static final class BuilderImpl implements Builder {
        private String availability;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainAvailabilityResponse model) {
            availability(model.availability);
        }

        public final String getAvailability() {
            return availability;
        }

        @Override
        public final Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        @Override
        public final Builder availability(DomainAvailability availability) {
            this.availability(availability.toString());
            return this;
        }

        public final void setAvailability(String availability) {
            this.availability = availability;
        }

        @Override
        public CheckDomainAvailabilityResponse build() {
            return new CheckDomainAvailabilityResponse(this);
        }
    }
}
