/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainTransferability response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CheckDomainTransferabilityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CheckDomainTransferabilityResponse.Builder, CheckDomainTransferabilityResponse> {
    private final DomainTransferability transferability;

    private CheckDomainTransferabilityResponse(BuilderImpl builder) {
        this.transferability = builder.transferability;
    }

    /**
     * <p>
     * A complex type that contains information about whether the specified domain can be transferred to Amazon Route
     * 53.
     * </p>
     * 
     * @return A complex type that contains information about whether the specified domain can be transferred to Amazon
     *         Route 53.
     */
    public DomainTransferability transferability() {
        return transferability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transferability());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainTransferabilityResponse)) {
            return false;
        }
        CheckDomainTransferabilityResponse other = (CheckDomainTransferabilityResponse) obj;
        return Objects.equals(transferability(), other.transferability());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (transferability() != null) {
            sb.append("Transferability: ").append(transferability()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transferability":
            return Optional.of(clazz.cast(transferability()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CheckDomainTransferabilityResponse> {
        /**
         * <p>
         * A complex type that contains information about whether the specified domain can be transferred to Amazon
         * Route 53.
         * </p>
         * 
         * @param transferability
         *        A complex type that contains information about whether the specified domain can be transferred to
         *        Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferability(DomainTransferability transferability);

        /**
         * <p>
         * A complex type that contains information about whether the specified domain can be transferred to Amazon
         * Route 53.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainTransferability.Builder} avoiding the need
         * to create one manually via {@link DomainTransferability#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainTransferability.Builder#build()} is called immediately and
         * its result is passed to {@link #transferability(DomainTransferability)}.
         * 
         * @param transferability
         *        a consumer that will call methods on {@link DomainTransferability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transferability(DomainTransferability)
         */
        default Builder transferability(Consumer<DomainTransferability.Builder> transferability) {
            return transferability(DomainTransferability.builder().apply(transferability).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DomainTransferability transferability;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainTransferabilityResponse model) {
            transferability(model.transferability);
        }

        public final DomainTransferability.Builder getTransferability() {
            return transferability != null ? transferability.toBuilder() : null;
        }

        @Override
        public final Builder transferability(DomainTransferability transferability) {
            this.transferability = transferability;
            return this;
        }

        public final void setTransferability(DomainTransferability.BuilderImpl transferability) {
            this.transferability = transferability != null ? transferability.build() : null;
        }

        @Override
        public CheckDomainTransferabilityResponse build() {
            return new CheckDomainTransferabilityResponse(this);
        }
    }
}
