/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetDomainDetail response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainDetailResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDomainDetailResponse.Builder, GetDomainDetailResponse> {
    private final String domainName;

    private final List<Nameserver> nameservers;

    private final Boolean autoRenew;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private final Boolean adminPrivacy;

    private final Boolean registrantPrivacy;

    private final Boolean techPrivacy;

    private final String registrarName;

    private final String whoIsServer;

    private final String registrarUrl;

    private final String abuseContactEmail;

    private final String abuseContactPhone;

    private final String registryDomainId;

    private final Instant creationDate;

    private final Instant updatedDate;

    private final Instant expirationDate;

    private final String reseller;

    private final String dnsSec;

    private final List<String> statusList;

    private GetDomainDetailResponse(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.nameservers = builder.nameservers;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
        this.registrarName = builder.registrarName;
        this.whoIsServer = builder.whoIsServer;
        this.registrarUrl = builder.registrarUrl;
        this.abuseContactEmail = builder.abuseContactEmail;
        this.abuseContactPhone = builder.abuseContactPhone;
        this.registryDomainId = builder.registryDomainId;
        this.creationDate = builder.creationDate;
        this.updatedDate = builder.updatedDate;
        this.expirationDate = builder.expirationDate;
        this.reseller = builder.reseller;
        this.dnsSec = builder.dnsSec;
        this.statusList = builder.statusList;
    }

    /**
     * <p>
     * The name of a domain.
     * </p>
     * 
     * @return The name of a domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The name of the domain.
     */
    public List<Nameserver> nameservers() {
        return nameservers;
    }

    /**
     * <p>
     * Specifies whether the domain registration is set to renew automatically.
     * </p>
     * 
     * @return Specifies whether the domain registration is set to renew automatically.
     */
    public Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Provides details about the domain administrative contact.
     * </p>
     * 
     * @return Provides details about the domain administrative contact.
     */
    public ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides details about the domain registrant.
     * </p>
     * 
     * @return Provides details about the domain registrant.
     */
    public ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides details about the domain technical contact.
     * </p>
     * 
     * @return Provides details about the domain technical contact.
     */
    public ContactDetail techContact() {
        return techContact;
    }

    /**
     * <p>
     * Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value is
     * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
     * instead of the contact information that you enter.
     * </p>
     * 
     * @return Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value
     *         is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner,
     *         Gandi, instead of the contact information that you enter.
     */
    public Boolean adminPrivacy() {
        return adminPrivacy;
    }

    /**
     * <p>
     * Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the value is
     * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
     * instead of the contact information that you enter.
     * </p>
     * 
     * @return Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the
     *         value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
     *         partner, Gandi, instead of the contact information that you enter.
     */
    public Boolean registrantPrivacy() {
        return registrantPrivacy;
    }

    /**
     * <p>
     * Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value is
     * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
     * instead of the contact information that you enter.
     * </p>
     * 
     * @return Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value
     *         is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner,
     *         Gandi, instead of the contact information that you enter.
     */
    public Boolean techPrivacy() {
        return techPrivacy;
    }

    /**
     * <p>
     * Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered by
     * registrar Gandi. The value is <code>"GANDI SAS"</code>.
     * </p>
     * 
     * @return Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered
     *         by registrar Gandi. The value is <code>"GANDI SAS"</code>.
     */
    public String registrarName() {
        return registrarName;
    }

    /**
     * <p>
     * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     * </p>
     * 
     * @return The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     */
    public String whoIsServer() {
        return whoIsServer;
    }

    /**
     * <p>
     * Web address of the registrar.
     * </p>
     * 
     * @return Web address of the registrar.
     */
    public String registrarUrl() {
        return registrarUrl;
    }

    /**
     * <p>
     * Email address to contact to report incorrect contact information for a domain, to report that the domain is being
     * used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     * </p>
     * 
     * @return Email address to contact to report incorrect contact information for a domain, to report that the domain
     *         is being used to send spam, to report that someone is cybersquatting on a domain name, or report some
     *         other type of abuse.
     */
    public String abuseContactEmail() {
        return abuseContactEmail;
    }

    /**
     * <p>
     * Phone number for reporting abuse.
     * </p>
     * 
     * @return Phone number for reporting abuse.
     */
    public String abuseContactPhone() {
        return abuseContactPhone;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String registryDomainId() {
        return registryDomainId;
    }

    /**
     * <p>
     * The date when the domain was created as found in the response to a WHOIS query. The date format is Unix time.
     * </p>
     * 
     * @return The date when the domain was created as found in the response to a WHOIS query. The date format is Unix
     *         time.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix time.
     * </p>
     * 
     * @return The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix
     *         time.
     */
    public Instant updatedDate() {
        return updatedDate;
    }

    /**
     * <p>
     * The date when the registration for the domain is set to expire. The date format is Unix time.
     * </p>
     * 
     * @return The date when the registration for the domain is set to expire. The date format is Unix time.
     */
    public Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
     * <code>"Amazon"</code> as the reseller.
     * </p>
     * 
     * @return Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
     *         <code>"Amazon"</code> as the reseller.
     */
    public String reseller() {
        return reseller;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String dnsSec() {
        return dnsSec;
    }

    /**
     * <p>
     * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
     * </p>
     * <p>
     * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
     * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
     * domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so
     * on. All registrars use this same set of status codes.
     * </p>
     * <p>
     * For a current list of domain name status codes and an explanation of what each code means, go to the <a
     * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
     * ICANN website; web searches sometimes return an old version of the document.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
     *         codes.</p>
     *         <p>
     *         ICANN, the organization that maintains a central database of domain names, has developed a set of domain
     *         name status codes that tell you the status of a variety of operations on a domain name, for example,
     *         registering a domain name, transferring a domain name to another registrar, renewing the registration for
     *         a domain name, and so on. All registrars use this same set of status codes.
     *         </p>
     *         <p>
     *         For a current list of domain name status codes and an explanation of what each code means, go to the <a
     *         href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on
     *         the ICANN website; web searches sometimes return an old version of the document.)
     */
    public List<String> statusList() {
        return statusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(nameservers());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(techContact());
        hashCode = 31 * hashCode + Objects.hashCode(adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(techPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(registrarName());
        hashCode = 31 * hashCode + Objects.hashCode(whoIsServer());
        hashCode = 31 * hashCode + Objects.hashCode(registrarUrl());
        hashCode = 31 * hashCode + Objects.hashCode(abuseContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(abuseContactPhone());
        hashCode = 31 * hashCode + Objects.hashCode(registryDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(reseller());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSec());
        hashCode = 31 * hashCode + Objects.hashCode(statusList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDetailResponse)) {
            return false;
        }
        GetDomainDetailResponse other = (GetDomainDetailResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(nameservers(), other.nameservers())
                && Objects.equals(autoRenew(), other.autoRenew()) && Objects.equals(adminContact(), other.adminContact())
                && Objects.equals(registrantContact(), other.registrantContact())
                && Objects.equals(techContact(), other.techContact()) && Objects.equals(adminPrivacy(), other.adminPrivacy())
                && Objects.equals(registrantPrivacy(), other.registrantPrivacy())
                && Objects.equals(techPrivacy(), other.techPrivacy()) && Objects.equals(registrarName(), other.registrarName())
                && Objects.equals(whoIsServer(), other.whoIsServer()) && Objects.equals(registrarUrl(), other.registrarUrl())
                && Objects.equals(abuseContactEmail(), other.abuseContactEmail())
                && Objects.equals(abuseContactPhone(), other.abuseContactPhone())
                && Objects.equals(registryDomainId(), other.registryDomainId())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(updatedDate(), other.updatedDate())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(reseller(), other.reseller())
                && Objects.equals(dnsSec(), other.dnsSec()) && Objects.equals(statusList(), other.statusList());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (nameservers() != null) {
            sb.append("Nameservers: ").append(nameservers()).append(",");
        }
        if (autoRenew() != null) {
            sb.append("AutoRenew: ").append(autoRenew()).append(",");
        }
        if (adminContact() != null) {
            sb.append("AdminContact: ").append(adminContact()).append(",");
        }
        if (registrantContact() != null) {
            sb.append("RegistrantContact: ").append(registrantContact()).append(",");
        }
        if (techContact() != null) {
            sb.append("TechContact: ").append(techContact()).append(",");
        }
        if (adminPrivacy() != null) {
            sb.append("AdminPrivacy: ").append(adminPrivacy()).append(",");
        }
        if (registrantPrivacy() != null) {
            sb.append("RegistrantPrivacy: ").append(registrantPrivacy()).append(",");
        }
        if (techPrivacy() != null) {
            sb.append("TechPrivacy: ").append(techPrivacy()).append(",");
        }
        if (registrarName() != null) {
            sb.append("RegistrarName: ").append(registrarName()).append(",");
        }
        if (whoIsServer() != null) {
            sb.append("WhoIsServer: ").append(whoIsServer()).append(",");
        }
        if (registrarUrl() != null) {
            sb.append("RegistrarUrl: ").append(registrarUrl()).append(",");
        }
        if (abuseContactEmail() != null) {
            sb.append("AbuseContactEmail: ").append(abuseContactEmail()).append(",");
        }
        if (abuseContactPhone() != null) {
            sb.append("AbuseContactPhone: ").append(abuseContactPhone()).append(",");
        }
        if (registryDomainId() != null) {
            sb.append("RegistryDomainId: ").append(registryDomainId()).append(",");
        }
        if (creationDate() != null) {
            sb.append("CreationDate: ").append(creationDate()).append(",");
        }
        if (updatedDate() != null) {
            sb.append("UpdatedDate: ").append(updatedDate()).append(",");
        }
        if (expirationDate() != null) {
            sb.append("ExpirationDate: ").append(expirationDate()).append(",");
        }
        if (reseller() != null) {
            sb.append("Reseller: ").append(reseller()).append(",");
        }
        if (dnsSec() != null) {
            sb.append("DnsSec: ").append(dnsSec()).append(",");
        }
        if (statusList() != null) {
            sb.append("StatusList: ").append(statusList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "Nameservers":
            return Optional.of(clazz.cast(nameservers()));
        case "AutoRenew":
            return Optional.of(clazz.cast(autoRenew()));
        case "AdminContact":
            return Optional.of(clazz.cast(adminContact()));
        case "RegistrantContact":
            return Optional.of(clazz.cast(registrantContact()));
        case "TechContact":
            return Optional.of(clazz.cast(techContact()));
        case "AdminPrivacy":
            return Optional.of(clazz.cast(adminPrivacy()));
        case "RegistrantPrivacy":
            return Optional.of(clazz.cast(registrantPrivacy()));
        case "TechPrivacy":
            return Optional.of(clazz.cast(techPrivacy()));
        case "RegistrarName":
            return Optional.of(clazz.cast(registrarName()));
        case "WhoIsServer":
            return Optional.of(clazz.cast(whoIsServer()));
        case "RegistrarUrl":
            return Optional.of(clazz.cast(registrarUrl()));
        case "AbuseContactEmail":
            return Optional.of(clazz.cast(abuseContactEmail()));
        case "AbuseContactPhone":
            return Optional.of(clazz.cast(abuseContactPhone()));
        case "RegistryDomainId":
            return Optional.of(clazz.cast(registryDomainId()));
        case "CreationDate":
            return Optional.of(clazz.cast(creationDate()));
        case "UpdatedDate":
            return Optional.of(clazz.cast(updatedDate()));
        case "ExpirationDate":
            return Optional.of(clazz.cast(expirationDate()));
        case "Reseller":
            return Optional.of(clazz.cast(reseller()));
        case "DnsSec":
            return Optional.of(clazz.cast(dnsSec()));
        case "StatusList":
            return Optional.of(clazz.cast(statusList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainDetailResponse> {
        /**
         * <p>
         * The name of a domain.
         * </p>
         * 
         * @param domainName
         *        The name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param nameservers
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Collection<Nameserver> nameservers);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param nameservers
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Nameserver... nameservers);

        /**
         * <p>
         * Specifies whether the domain registration is set to renew automatically.
         * </p>
         * 
         * @param autoRenew
         *        Specifies whether the domain registration is set to renew automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Provides details about the domain administrative contact.
         * </p>
         * 
         * @param adminContact
         *        Provides details about the domain administrative contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides details about the domain administrative contact.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #adminContact(ContactDetail)}.
         * 
         * @param adminContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminContact(ContactDetail)
         */
        default Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return adminContact(ContactDetail.builder().apply(adminContact).build());
        }

        /**
         * <p>
         * Provides details about the domain registrant.
         * </p>
         * 
         * @param registrantContact
         *        Provides details about the domain registrant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides details about the domain registrant.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #registrantContact(ContactDetail)}.
         * 
         * @param registrantContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrantContact(ContactDetail)
         */
        default Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return registrantContact(ContactDetail.builder().apply(registrantContact).build());
        }

        /**
         * <p>
         * Provides details about the domain technical contact.
         * </p>
         * 
         * @param techContact
         *        Provides details about the domain technical contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Provides details about the domain technical contact.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #techContact(ContactDetail)}.
         * 
         * @param techContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #techContact(ContactDetail)
         */
        default Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return techContact(ContactDetail.builder().apply(techContact).build());
        }

        /**
         * <p>
         * Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the value is
         * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
         * instead of the contact information that you enter.
         * </p>
         * 
         * @param adminPrivacy
         *        Specifies whether contact information for the admin contact is concealed from WHOIS queries. If the
         *        value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
         *        partner, Gandi, instead of the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPrivacy(Boolean adminPrivacy);

        /**
         * <p>
         * Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If the
         * value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
         * partner, Gandi, instead of the contact information that you enter.
         * </p>
         * 
         * @param registrantPrivacy
         *        Specifies whether contact information for the registrant contact is concealed from WHOIS queries. If
         *        the value is <code>true</code>, WHOIS ("who is") queries will return contact information for our
         *        registrar partner, Gandi, instead of the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantPrivacy(Boolean registrantPrivacy);

        /**
         * <p>
         * Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the value is
         * <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar partner, Gandi,
         * instead of the contact information that you enter.
         * </p>
         * 
         * @param techPrivacy
         *        Specifies whether contact information for the tech contact is concealed from WHOIS queries. If the
         *        value is <code>true</code>, WHOIS ("who is") queries will return contact information for our registrar
         *        partner, Gandi, instead of the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techPrivacy(Boolean techPrivacy);

        /**
         * <p>
         * Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are registered by
         * registrar Gandi. The value is <code>"GANDI SAS"</code>.
         * </p>
         * 
         * @param registrarName
         *        Name of the registrar of the domain as identified in the registry. Amazon Route 53 domains are
         *        registered by registrar Gandi. The value is <code>"GANDI SAS"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrarName(String registrarName);

        /**
         * <p>
         * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         * </p>
         * 
         * @param whoIsServer
         *        The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whoIsServer(String whoIsServer);

        /**
         * <p>
         * Web address of the registrar.
         * </p>
         * 
         * @param registrarUrl
         *        Web address of the registrar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrarUrl(String registrarUrl);

        /**
         * <p>
         * Email address to contact to report incorrect contact information for a domain, to report that the domain is
         * being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type
         * of abuse.
         * </p>
         * 
         * @param abuseContactEmail
         *        Email address to contact to report incorrect contact information for a domain, to report that the
         *        domain is being used to send spam, to report that someone is cybersquatting on a domain name, or
         *        report some other type of abuse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abuseContactEmail(String abuseContactEmail);

        /**
         * <p>
         * Phone number for reporting abuse.
         * </p>
         * 
         * @param abuseContactPhone
         *        Phone number for reporting abuse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abuseContactPhone(String abuseContactPhone);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param registryDomainId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryDomainId(String registryDomainId);

        /**
         * <p>
         * The date when the domain was created as found in the response to a WHOIS query. The date format is Unix time.
         * </p>
         * 
         * @param creationDate
         *        The date when the domain was created as found in the response to a WHOIS query. The date format is
         *        Unix time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix time.
         * </p>
         * 
         * @param updatedDate
         *        The last updated date of the domain as found in the response to a WHOIS query. The date format is Unix
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedDate(Instant updatedDate);

        /**
         * <p>
         * The date when the registration for the domain is set to expire. The date format is Unix time.
         * </p>
         * 
         * @param expirationDate
         *        The date when the registration for the domain is set to expire. The date format is Unix time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
         * <code>"Amazon"</code> as the reseller.
         * </p>
         * 
         * @param reseller
         *        Reseller of the domain. Domains registered or transferred using Amazon Route 53 domains will have
         *        <code>"Amazon"</code> as the reseller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reseller(String reseller);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param dnsSec
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSec(String dnsSec);

        /**
         * <p>
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         * </p>
         * <p>
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
         * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
         * domain name, transferring a domain name to another registrar, renewing the registration for a domain name,
         * and so on. All registrars use this same set of status codes.
         * </p>
         * <p>
         * For a current list of domain name status codes and an explanation of what each code means, go to the <a
         * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
         * ICANN website; web searches sometimes return an old version of the document.)
         * </p>
         * 
         * @param statusList
         *        An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
         *        codes.</p>
         *        <p>
         *        ICANN, the organization that maintains a central database of domain names, has developed a set of
         *        domain name status codes that tell you the status of a variety of operations on a domain name, for
         *        example, registering a domain name, transferring a domain name to another registrar, renewing the
         *        registration for a domain name, and so on. All registrars use this same set of status codes.
         *        </p>
         *        <p>
         *        For a current list of domain name status codes and an explanation of what each code means, go to the
         *        <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
         *        (Search on the ICANN website; web searches sometimes return an old version of the document.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(Collection<String> statusList);

        /**
         * <p>
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         * </p>
         * <p>
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
         * status codes that tell you the status of a variety of operations on a domain name, for example, registering a
         * domain name, transferring a domain name to another registrar, renewing the registration for a domain name,
         * and so on. All registrars use this same set of status codes.
         * </p>
         * <p>
         * For a current list of domain name status codes and an explanation of what each code means, go to the <a
         * href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the
         * ICANN website; web searches sometimes return an old version of the document.)
         * </p>
         * 
         * @param statusList
         *        An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status
         *        codes.</p>
         *        <p>
         *        ICANN, the organization that maintains a central database of domain names, has developed a set of
         *        domain name status codes that tell you the status of a variety of operations on a domain name, for
         *        example, registering a domain name, transferring a domain name to another registrar, renewing the
         *        registration for a domain name, and so on. All registrars use this same set of status codes.
         *        </p>
         *        <p>
         *        For a current list of domain name status codes and an explanation of what each code means, go to the
         *        <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
         *        (Search on the ICANN website; web searches sometimes return an old version of the document.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusList(String... statusList);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private List<Nameserver> nameservers;

        private Boolean autoRenew;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private Boolean adminPrivacy;

        private Boolean registrantPrivacy;

        private Boolean techPrivacy;

        private String registrarName;

        private String whoIsServer;

        private String registrarUrl;

        private String abuseContactEmail;

        private String abuseContactPhone;

        private String registryDomainId;

        private Instant creationDate;

        private Instant updatedDate;

        private Instant expirationDate;

        private String reseller;

        private String dnsSec;

        private List<String> statusList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDetailResponse model) {
            domainName(model.domainName);
            nameservers(model.nameservers);
            autoRenew(model.autoRenew);
            adminContact(model.adminContact);
            registrantContact(model.registrantContact);
            techContact(model.techContact);
            adminPrivacy(model.adminPrivacy);
            registrantPrivacy(model.registrantPrivacy);
            techPrivacy(model.techPrivacy);
            registrarName(model.registrarName);
            whoIsServer(model.whoIsServer);
            registrarUrl(model.registrarUrl);
            abuseContactEmail(model.abuseContactEmail);
            abuseContactPhone(model.abuseContactPhone);
            registryDomainId(model.registryDomainId);
            creationDate(model.creationDate);
            updatedDate(model.updatedDate);
            expirationDate(model.expirationDate);
            reseller(model.reseller);
            dnsSec(model.dnsSec);
            statusList(model.statusList);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Nameserver.Builder> getNameservers() {
            return nameservers != null ? nameservers.stream().map(Nameserver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver... nameservers) {
            nameservers(Arrays.asList(nameservers));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return adminContact != null ? adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return registrantContact != null ? registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return techContact != null ? techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getAdminPrivacy() {
            return adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        public final String getRegistrarName() {
            return registrarName;
        }

        @Override
        public final Builder registrarName(String registrarName) {
            this.registrarName = registrarName;
            return this;
        }

        public final void setRegistrarName(String registrarName) {
            this.registrarName = registrarName;
        }

        public final String getWhoIsServer() {
            return whoIsServer;
        }

        @Override
        public final Builder whoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
            return this;
        }

        public final void setWhoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
        }

        public final String getRegistrarUrl() {
            return registrarUrl;
        }

        @Override
        public final Builder registrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
            return this;
        }

        public final void setRegistrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
        }

        public final String getAbuseContactEmail() {
            return abuseContactEmail;
        }

        @Override
        public final Builder abuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
            return this;
        }

        public final void setAbuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
        }

        public final String getAbuseContactPhone() {
            return abuseContactPhone;
        }

        @Override
        public final Builder abuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
            return this;
        }

        public final void setAbuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
        }

        public final String getRegistryDomainId() {
            return registryDomainId;
        }

        @Override
        public final Builder registryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
            return this;
        }

        public final void setRegistryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdatedDate() {
            return updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getReseller() {
            return reseller;
        }

        @Override
        public final Builder reseller(String reseller) {
            this.reseller = reseller;
            return this;
        }

        public final void setReseller(String reseller) {
            this.reseller = reseller;
        }

        public final String getDnsSec() {
            return dnsSec;
        }

        @Override
        public final Builder dnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
            return this;
        }

        public final void setDnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
        }

        public final Collection<String> getStatusList() {
            return statusList;
        }

        @Override
        public final Builder statusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(String... statusList) {
            statusList(Arrays.asList(statusList));
            return this;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
        }

        @Override
        public GetDomainDetailResponse build() {
            return new GetDomainDetailResponse(this);
        }
    }
}
